/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundOutputInspectionResultsPacket;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtil;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.antlr.v4.runtime.misc.Pair;

public record ServerboundOutputInspectionRequestPacket(String programString, int outputNodeIndex) {
    public static void encode(ServerboundOutputInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130072_(msg.programString, 80960);
        friendlyByteBuf.writeInt(msg.outputNodeIndex());
    }

    public static ServerboundOutputInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundOutputInspectionRequestPacket(friendlyByteBuf.m_130136_(80960), friendlyByteBuf.readInt());
    }

    private static <STACK, ITEM, CAP> ResourceLimit<STACK, ITEM, CAP> getSlotResource(LimitedInputSlot<STACK, ITEM, CAP> limitedInputSlot) {
        ResourceType resourceType = limitedInputSlot.type;
        ResourceKey resourceTypeResourceKey = SFMResourceTypes.DEFERRED_TYPES.get().getResourceKey(limitedInputSlot.type).map(x -> x).get();
        STACK stack = limitedInputSlot.peekExtractPotential();
        long amount = limitedInputSlot.type.getAmount(stack);
        amount = Long.min(amount, limitedInputSlot.tracker.getResourceLimit().limit().quantity().number().value());
        long remainingObligation = limitedInputSlot.tracker.getRemainingRetentionObligation();
        amount -= Long.min(amount, remainingObligation);
        Limit amountLimit = new Limit(new ResourceQuantity(new Number(amount), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), ResourceQuantity.MAX_QUANTITY);
        ResourceLocation stackId = resourceType.getRegistryKey(stack);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.m_135782_().m_135827_(), resourceTypeResourceKey.m_135782_().m_135815_(), stackId.m_135827_(), stackId.m_135815_());
        return new ResourceLimit(resourceIdentifier, amountLimit);
    }

    public static void handle(ServerboundOutputInspectionRequestPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ManagerBlockEntity mbe;
            BlockEntity patt4175$temp;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt4060$temp = player.f_36096_;
            if (patt4060$temp instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)patt4060$temp;
                patt4175$temp = player.m_9236_().m_7702_(mcm.MANAGER_POSITION);
                if (!(patt4175$temp instanceof ManagerBlockEntity)) {
                    return;
                }
            } else {
                SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager."));
                return;
            }
            ManagerBlockEntity manager = mbe = (ManagerBlockEntity)patt4175$temp;
            Program.compile(msg.programString, (successProgram, builder) -> builder.getNodeAtIndex(msg.outputNodeIndex).filter(OutputStatement.class::isInstance).map(OutputStatement.class::cast).ifPresent(outputStatement -> {
                final StringBuilder payload = new StringBuilder();
                payload.append(outputStatement.toStringPretty()).append("\n");
                payload.append("-- predictions may differ from actual execution results\n");
                successProgram.replaceOutputStatement((OutputStatement)outputStatement, new OutputStatement(outputStatement.labelAccess(), outputStatement.resourceLimits(), outputStatement.each(), (OutputStatement)outputStatement, (Program)successProgram){
                    final /* synthetic */ OutputStatement val$outputStatement;
                    final /* synthetic */ Program val$successProgram;
                    {
                        this.val$outputStatement = outputStatement;
                        this.val$successProgram = program;
                        super(labelAccess, resourceLimits, each);
                    }

                    @Override
                    public void tick(ProgramContext context) {
                        StringBuilder branchPayload = new StringBuilder();
                        if (!context.getExecutionPath().isEmpty()) {
                            payload.append("-- POSSIBILITY ").append(context.getExplorationBranchIndex()).append(" --\n");
                            context.getExecutionPath().forEach(branch -> {
                                if (branch.wasTrue()) {
                                    payload.append(branch.ifStatement().condition().sourceCode()).append(" -- true");
                                } else {
                                    payload.append(branch.ifStatement().condition().negate().sourceCode());
                                }
                                payload.append("\n");
                            });
                            payload.append("\n");
                        }
                        branchPayload.append("-- predicted inputs:\n");
                        ArrayList inputSlots = new ArrayList();
                        context.getInputs().forEach(inputStatement -> inputStatement.gatherSlots(context, (LimitedInputSlot<?, ?, ?> slot) -> inputSlots.add(new Pair(slot, (Object)inputStatement.labelAccess()))));
                        List<InputStatement> inputStatements = inputSlots.stream().map(slot -> SFMUtil.getInputStatementForSlot((LimitedInputSlot)slot.a, (LabelAccess)slot.b)).filter(Optional::isPresent).map(Optional::get).toList();
                        if (inputStatements.isEmpty()) {
                            branchPayload.append("none\n-- predicted outputs:\nnone");
                        } else {
                            inputStatements.stream().map(InputStatement::toStringPretty).map(x -> x + "\n").forEach(branchPayload::append);
                            branchPayload.append("-- predicted outputs:\n");
                            ResourceLimits resourceLimits = new ResourceLimits(inputSlots.stream().map(slot -> (LimitedInputSlot)slot.a).map(ServerboundOutputInspectionRequestPacket::getSlotResource).toList(), ResourceIdSet.EMPTY);
                            ArrayList condensedResourceLimitList = new ArrayList();
                            for (ResourceLimit<?, ?, ?> resourceLimit : resourceLimits.resourceLimits()) {
                                condensedResourceLimitList.stream().filter(x -> x.resourceId().equals(resourceLimit.resourceId())).findFirst().ifPresentOrElse(found -> {
                                    int i = condensedResourceLimitList.indexOf(found);
                                    ResourceLimit newLimit = found.withLimit(new Limit(found.limit().quantity().add(resourceLimit.limit().quantity()), ResourceQuantity.MAX_QUANTITY));
                                    condensedResourceLimitList.set(i, newLimit);
                                }, () -> condensedResourceLimitList.add(resourceLimit));
                            }
                            ListIterator iter = condensedResourceLimitList.listIterator();
                            while (iter.hasNext()) {
                                ResourceLimit resourceLimit = (ResourceLimit)iter.next();
                                ResourceLocation resourceLimitLocation = new ResourceLocation(resourceLimit.resourceId().resourceNamespace, resourceLimit.resourceId().resourceName);
                                long accept = this.val$outputStatement.resourceLimits().resourceLimits().stream().filter(outputResourceLimit -> ResourceType.stackIdMatches(outputResourceLimit.resourceId(), resourceLimitLocation) && this.val$outputStatement.resourceLimits().exclusions().resourceIds().stream().noneMatch(exclusion -> ResourceType.stackIdMatches(exclusion, resourceLimitLocation))).mapToLong(rl -> rl.limit().quantity().number().value()).max().orElse(0L);
                                if (accept == 0L) {
                                    iter.remove();
                                    continue;
                                }
                                iter.set(resourceLimit.withLimit(new Limit(new ResourceQuantity(new Number(Long.min(accept, resourceLimit.limit().quantity().number().value())), resourceLimit.limit().quantity().idExpansionBehaviour()), ResourceQuantity.MAX_QUANTITY)));
                            }
                            ResourceLimits condensedResourceLimits = new ResourceLimits(condensedResourceLimitList, ResourceIdSet.EMPTY);
                            if (condensedResourceLimits.resourceLimits().isEmpty()) {
                                branchPayload.append("none\n");
                            } else {
                                branchPayload.append(new OutputStatement(this.val$outputStatement.labelAccess(), condensedResourceLimits, this.val$outputStatement.each()).toStringPretty());
                            }
                        }
                        branchPayload.append("\n");
                        if (this.val$successProgram.getConditionCount() == 0) {
                            payload.append((CharSequence)branchPayload);
                        } else {
                            payload.append(branchPayload.toString().indent(4));
                        }
                    }
                });
                int branchIndex = 0;
                while ((double)branchIndex < Math.pow(2.0, successProgram.getConditionCount())) {
                    successProgram.tick(new ProgramContext((Program)successProgram, manager, ProgramContext.ExecutionPolicy.EXPLORE_BRANCHES, branchIndex));
                    ++branchIndex;
                }
                SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundOutputInspectionResultsPacket(payload.toString().strip()));
            }), failure -> SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundOutputInspectionResultsPacket("failed to compile program")));
        });
    }
}

