/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.compat.SFMCompat;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.net.ClientboundContainerExportsInspectionResultsPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtil;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public record ServerboundContainerExportsInspectionRequestPacket(int windowId, BlockPos pos) {
    public static void encode(ServerboundContainerExportsInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130130_(msg.windowId());
        friendlyByteBuf.m_130064_(msg.pos());
    }

    public static ServerboundContainerExportsInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundContainerExportsInspectionRequestPacket(friendlyByteBuf.m_130242_(), friendlyByteBuf.m_130135_());
    }

    public static void handle(ServerboundContainerExportsInspectionRequestPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        SFMPackets.handleServerboundContainerPacket(contextSupplier, AbstractContainerMenu.class, BlockEntity.class, msg.pos, msg.windowId, (menu, blockEntity) -> {
            assert (blockEntity.m_58904_() != null);
            String payload = ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((LevelAccessor)blockEntity.m_58904_(), blockEntity.m_58899_());
            SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)((NetworkEvent.Context)contextSupplier.get())).getSender()), (Object)new ClientboundContainerExportsInspectionResultsPacket(msg.windowId, payload));
        });
    }

    public static String buildInspectionResults(LevelAccessor level, BlockPos pos) {
        BlockEntity be;
        StringBuilder sb = new StringBuilder();
        Direction[] dirs = Arrays.copyOf(Direction.values(), Direction.values().length + 1);
        dirs[dirs.length - 1] = null;
        for (Direction direction : dirs) {
            sb.append("-- ").append(direction).append("\n");
            int len = sb.length();
            SFMResourceTypes.DEFERRED_TYPES.get().getEntries().forEach(entry -> sb.append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((ResourceKey)entry.getKey(), (ResourceType)entry.getValue(), level, pos, direction)));
            if (sb.length() == len) {
                sb.append("No exports found");
            }
            sb.append("\n");
        }
        if (SFMCompat.isMekanismLoaded() && (be = level.m_7702_(pos)) != null) {
            sb.append(SFMMekanismCompat.gatherInspectionResults(be)).append("\n");
        }
        return sb.toString();
    }

    private static <STACK, ITEM, CAP> String buildInspectionResults(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeResourceKey, ResourceType<STACK, ITEM, CAP> resourceType, LevelAccessor level, BlockPos pos, @Nullable Direction direction) {
        BlockEntity be;
        StringBuilder sb = new StringBuilder();
        SFMUtil.discoverCapabilityProvider(level, pos).ifPresent(prov -> prov.getCapability(resourceType.CAPABILITY, direction).ifPresent(cap -> {
            int slots = resourceType.getSlots(cap);
            Int2ObjectArrayMap slotContents = new Int2ObjectArrayMap(slots);
            for (int slot2 = 0; slot2 < slots; ++slot2) {
                Object stack2 = resourceType.getStackInSlot(cap, slot2);
                if (resourceType.isEmpty(stack2)) continue;
                slotContents.put(slot2, stack2);
            }
            if (!slotContents.isEmpty()) {
                slotContents.forEach((slot, stack) -> {
                    InputStatement inputStatement = SFMUtil.getInputStatementForStack(resourceTypeResourceKey, resourceType, stack, "target", slot, false, direction);
                    sb.append(inputStatement.toStringPretty()).append("\n");
                });
                ArrayList resourceLimitList = new ArrayList();
                slotContents.forEach((slot, stack) -> {
                    ResourceLocation stackId = resourceType.getRegistryKey(stack);
                    ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.m_135782_().m_135827_(), resourceTypeResourceKey.m_135782_().m_135815_(), stackId.m_135827_(), stackId.m_135815_());
                    ResourceLimit resourceLimit = new ResourceLimit(resourceIdentifier, Limit.MAX_QUANTITY_NO_RETENTION);
                    resourceLimitList.add(resourceLimit);
                });
                InputStatement inputStatement = new InputStatement(new LabelAccess(List.of(new Label("target")), new DirectionQualifier(direction == null ? EnumSet.noneOf(Direction.class) : EnumSet.of(direction)), NumberRangeSet.MAX_RANGE), new ResourceLimits(resourceLimitList.stream().distinct().toList(), ResourceIdSet.EMPTY), false);
                sb.append(inputStatement.toStringPretty());
            }
        }));
        String result = sb.toString();
        if (!result.isBlank() && (be = level.m_7702_(pos)) != null && direction == null && ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_()).m_135827_().equals("mekanism")) {
            return "-- " + Constants.LocalizationKeys.CONTAINER_INSPECTOR_MEKANISM_NULL_DIRECTION_WARNING.getString() + "\n" + result;
        }
        return result;
    }
}

