/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.handler;

import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.recipe.PrintingPressRecipe;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FallingAnvilHandler {
    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent event) {
        FallingBlockEntity fbe;
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlockEntity && (fbe = (FallingBlockEntity)entity).m_31980_().m_60734_() instanceof AnvilBlock) {
            BlockPos landPosition = fbe.m_20183_();
            Level level = event.getLevel();
            Block block = level.m_8055_(landPosition.m_7495_()).m_60734_();
            if (block == Blocks.f_50075_) {
                List recipes = level.m_7465_().m_44013_((RecipeType)SFMRecipeTypes.PRINTING_PRESS.get());
                List<ItemEntity> items = level.m_45976_(ItemEntity.class, new AABB(landPosition)).stream().filter(Entity::m_6084_).filter(e -> !e.m_32055_().m_41619_()).toList();
                boolean didForm = false;
                block0: for (ItemEntity item : items) {
                    for (PrintingPressRecipe recipe : recipes) {
                        if (!recipe.FORM.test(item.m_32055_())) continue;
                        didForm = true;
                        item.m_32045_(FormItem.getForm(item.m_32055_()));
                        continue block0;
                    }
                }
                if (didForm) {
                    level.m_46597_(landPosition.m_7495_(), Blocks.f_50016_.m_49966_());
                }
            } else if (block == Blocks.f_50080_) {
                List<ItemEntity> items = level.m_45976_(ItemEntity.class, new AABB(landPosition)).stream().filter(Entity::m_6084_).filter(e -> !e.m_32055_().m_41619_()).toList();
                items.stream().filter(e -> e.m_32055_().m_150930_(Items.f_42690_)).forEach(e -> e.m_32045_(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get(), e.m_32055_().m_41613_())));
                List<ItemEntity> bookEntities = items.stream().filter(e -> e.m_32055_().m_150930_(Items.f_42517_)).toList();
                int booksAvailable = bookEntities.stream().mapToInt(e -> e.m_32055_().m_41613_()).sum();
                List<ItemEntity> enchanted = items.stream().filter(e -> !e.m_32055_().m_41785_().isEmpty()).toList();
                block2: for (ItemEntity enchItemEntity : enchanted) {
                    ItemStack enchStack = enchItemEntity.m_32055_();
                    int enchStackSize = enchStack.m_41613_();
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)enchStack);
                    Iterator enchIter = enchantments.entrySet().iterator();
                    while (enchIter.hasNext()) {
                        Map.Entry entry = enchIter.next();
                        if (booksAvailable < enchStackSize) continue block2;
                        ItemStack toSpawn = new ItemStack((ItemLike)Items.f_42690_, enchStackSize);
                        EnchantedBookItem.m_41153_((ItemStack)toSpawn, (EnchantmentInstance)new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                        level.m_7967_((Entity)new ItemEntity(level, (double)landPosition.m_123341_(), (double)landPosition.m_123342_(), (double)landPosition.m_123343_(), toSpawn));
                        enchIter.remove();
                        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)enchStack);
                        booksAvailable -= enchStackSize;
                        if (!enchantments.isEmpty()) continue;
                        continue block2;
                    }
                }
                for (ItemEntity bookEntity : bookEntities) {
                    bookEntity.m_6074_();
                }
                while (booksAvailable > 0) {
                    int toSpawn = Math.min(booksAvailable, 64);
                    level.m_7967_((Entity)new ItemEntity(level, (double)landPosition.m_123341_(), (double)landPosition.m_123342_(), (double)landPosition.m_123343_(), new ItemStack((ItemLike)Items.f_42517_, toSpawn)));
                    booksAvailable -= toSpawn;
                }
            }
        }
    }
}

