/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.ICable;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CableNetwork {
    protected final Level LEVEL;
    protected final Set<BlockPos> CABLES = new HashSet<BlockPos>();
    protected final Map<BlockPos, ICapabilityProvider> CAPABILITY_PROVIDERS = new HashMap<BlockPos, ICapabilityProvider>();

    public CableNetwork(Level level) {
        this.LEVEL = level;
    }

    public static boolean isCable(@Nullable Level world, BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.m_8055_(cablePos).m_60734_() instanceof ICable;
    }

    public void rebuildNetwork(BlockPos pos) {
        this.CABLES.clear();
        this.CAPABILITY_PROVIDERS.clear();
        this.discoverCables(pos).forEach(this::addCable);
    }

    public Stream<BlockPos> discoverCables(BlockPos startPos) {
        return SFMUtil.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.m_121955_(d.m_122436_());
                if (!CableNetwork.isCable(this.getLevel(), offset)) continue;
                next.accept(offset);
            }
        }, startPos);
    }

    public void addCable(BlockPos pos) {
        boolean isNewMember = this.CABLES.add(pos);
        if (isNewMember) {
            this.rebuildAdjacentInventories(pos);
        }
    }

    public Level getLevel() {
        return this.LEVEL;
    }

    public void rebuildAdjacentInventories(BlockPos cablePos) {
        Arrays.stream(Direction.values()).map(Direction::m_122436_).map(arg_0 -> ((BlockPos)cablePos).m_121955_(arg_0)).distinct().peek(this.CAPABILITY_PROVIDERS::remove).filter(this::hasCableNeighbour).map(pos -> SFMUtil.discoverCapabilityProvider((LevelAccessor)this.LEVEL, pos).map(prov -> Pair.of((Object)pos, (Object)prov))).filter(Optional::isPresent).map(Optional::get).forEach(prov -> this.CAPABILITY_PROVIDERS.put((BlockPos)prov.getFirst(), (ICapabilityProvider)prov.getSecond()));
    }

    public boolean hasCableNeighbour(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.CABLES.contains(pos.m_121955_(direction.m_122436_()))) continue;
            return true;
        }
        return false;
    }

    public boolean containsCableLocation(BlockPos pos) {
        return this.CABLES.contains(pos);
    }

    public boolean isInNetwork(BlockPos pos) {
        return this.CAPABILITY_PROVIDERS.containsKey(pos);
    }

    public Optional<ICapabilityProvider> getCapabilityProvider(BlockPos pos) {
        return Optional.ofNullable(this.CAPABILITY_PROVIDERS.get(pos));
    }

    public int size() {
        return this.CABLES.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLES.addAll(other.CABLES);
        this.CAPABILITY_PROVIDERS.putAll(other.CAPABILITY_PROVIDERS);
    }

    public boolean isEmpty() {
        return this.CABLES.isEmpty();
    }

    public Map<BlockPos, ICapabilityProvider> getCapabilityProviders() {
        return Collections.unmodifiableMap(this.CAPABILITY_PROVIDERS);
    }

    public Set<BlockPos> getCables() {
        return Collections.unmodifiableSet(this.CABLES);
    }

    protected List<CableNetwork> withoutCable(BlockPos cablePos) {
        ArrayList<CableNetwork> branches = new ArrayList<CableNetwork>();
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = cablePos.m_121955_(direction.m_122436_());
            if (!CableNetwork.isCable(this.getLevel(), offsetPos) || branches.stream().anyMatch(n -> n.containsCableLocation(offsetPos))) continue;
            CableNetwork branchNetwork = new CableNetwork(this.getLevel());
            branchNetwork.rebuildNetwork(offsetPos);
            branches.add(branchNetwork);
        }
        return branches;
    }
}

