/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.blockentity.WaterTankBlockEntity;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class WaterTankBlock
extends BaseEntityBlock
implements EntityBlock,
BucketPickup,
LiquidBlockContainer {
    public static final BooleanProperty IN_WATER = BooleanProperty.m_61465_((String)"in_water");

    public WaterTankBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_155954_(2.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)IN_WATER, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        for (Direction direction : Direction.values()) {
            this.recount(pLevel, pPos.m_121955_(direction.m_122436_()));
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        for (Direction direction : Direction.values()) {
            this.recount(pLevel, pPos.m_121955_(direction.m_122436_()));
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Constants.LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_1.getComponent().m_130940_(ChatFormatting.GRAY));
        pTooltip.add((Component)Constants.LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_2.getComponent().m_130940_(ChatFormatting.GRAY));
    }

    public void recount(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof WaterTankBlockEntity)) {
            return;
        }
        WaterTankBlockEntity be = (WaterTankBlockEntity)blockEntity;
        List<WaterTankBlockEntity> tanks = SFMUtil.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.m_58899_().m_121955_(d.m_122436_());
                BlockEntity patt3694$temp = level.m_7702_(offset);
                if (!(patt3694$temp instanceof WaterTankBlockEntity)) continue;
                WaterTankBlockEntity blockEntity = (WaterTankBlockEntity)patt3694$temp;
                next.accept(blockEntity);
            }
        }, be).toList();
        tanks.forEach(t -> t.setConnectedCount(tanks.size()));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IN_WATER});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)IN_WATER, (Comparable)Boolean.valueOf(this.isActive((LevelAccessor)context.m_43725_(), context.m_8083_())));
    }

    public boolean isActive(LevelAccessor level, BlockPos pos) {
        int neighbourWaterCount = 0;
        for (Direction direction : Direction.values()) {
            FluidState state = level.m_6425_(pos.m_121945_(direction));
            if (!state.m_76170_() || !state.m_205070_(FluidTags.f_13131_) || ++neighbourWaterCount != 2) continue;
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        boolean isActive = this.isActive((LevelAccessor)level, pos);
        if ((Boolean)state.m_61143_((Property)IN_WATER) != isActive) {
            BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)IN_WATER, (Comparable)Boolean.valueOf(isActive));
            level.m_7731_(pos, newState, 3);
        }
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)IN_WATER) != false ? new ItemStack((ItemLike)Fluids.f_76193_.m_6859_()) : ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return fluid.m_6212_((Fluid)Fluids.f_76193_);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluid) {
        return fluid.m_76152_().m_6212_((Fluid)Fluids.f_76193_);
    }
}

