/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common;

import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.registry.SFMItems;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class Constants {

    public static final class LocalizationKeys {
        public static final LocalizationEntry PROGRAM_EDIT_SCREEN_TITLE = new LocalizationEntry("gui.sfm.text_editor.title", "Text Editor");
        public static final LocalizationEntry PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP = new LocalizationEntry("gui.sfm.text_editor.done_button.tooltip", "Shift+Enter to submit");
        public static LocalizationEntry MOD_NAME = new LocalizationEntry("mod.name", "Super Factory Manager");
        public static LocalizationEntry ITEM_GROUP = new LocalizationEntry("itemGroup.sfm", "Super Factory Manager");
        public static LocalizationEntry CABLE_BLOCK = new LocalizationEntry(() -> ((Block)SFMBlocks.CABLE_BLOCK.get()).m_7705_(), () -> "Inventory Cable");
        public static LocalizationEntry MANAGER_BLOCK = new LocalizationEntry(() -> ((Block)SFMBlocks.MANAGER_BLOCK.get()).m_7705_(), () -> "Factory Manager");
        public static LocalizationEntry PRINTING_PRESS_BLOCK = new LocalizationEntry(() -> ((Block)SFMBlocks.PRINTING_PRESS_BLOCK.get()).m_7705_(), () -> "Printing Press");
        public static final LocalizationEntry PRINTING_PRESS_JEI_CATEGORY_TITLE = new LocalizationEntry("gui.jei.category.sfm.printing_press", "Printing Press");
        public static final LocalizationEntry FALLING_ANVIL_JEI_CATEGORY_TITLE = new LocalizationEntry("gui.jei.category.sfm.falling_anvil", "Falling Anvil");
        public static final LocalizationEntry FALLING_ANVIL_JEI_CONSUMED = new LocalizationEntry("gui.jei.category.sfm.falling_anvil.consumed", "Gets consumed");
        public static final LocalizationEntry FALLING_ANVIL_JEI_NOT_CONSUMED = new LocalizationEntry("gui.jei.category.sfm.falling_anvil.not_consumed", "Not consumed");
        public static final LocalizationEntry PRINTING_PRESS_TOOLTIP = new LocalizationEntry(() -> ((Item)SFMItems.PRINTING_PRESS_ITEM.get()).m_5524_() + ".tooltip", () -> "Place with an air gap below a downward facing piston. Extend the piston to use.");
        public static LocalizationEntry TEST_BARREL_BLOCK = new LocalizationEntry(() -> ((Block)SFMBlocks.TEST_BARREL_BLOCK.get()).m_7705_(), () -> "Test Barrel");
        public static LocalizationEntry WATER_TANK_BLOCK = new LocalizationEntry(() -> ((Block)SFMBlocks.WATER_TANK_BLOCK.get()).m_7705_(), () -> "Water Tank");
        public static LocalizationEntry BATTERY_BLOCK = new LocalizationEntry(() -> ((Block)SFMBlocks.BATTERY_BLOCK.get()).m_7705_(), () -> "Battery (WIP)");
        public static LocalizationEntry DISK_ITEM = new LocalizationEntry(() -> ((Item)SFMItems.DISK_ITEM.get()).m_5524_(), () -> "Factory Manager Program Disk");
        public static LocalizationEntry EXPERIENCE_GOOP_ITEM = new LocalizationEntry(() -> ((Item)SFMItems.EXPERIENCE_GOOP_ITEM.get()).m_5524_(), () -> "Experience Goop");
        public static LocalizationEntry EXPERIENCE_SHARD_ITEM = new LocalizationEntry(() -> ((Item)SFMItems.EXPERIENCE_SHARD_ITEM.get()).m_5524_(), () -> "Experience Shard");
        public static LocalizationEntry FORM_ITEM = new LocalizationEntry(() -> ((Item)SFMItems.FORM_ITEM.get()).m_5524_(), () -> "Printing Form");
        public static final LocalizationEntry DISK_ITEM_TOOLTIP_LABEL_HEADER = new LocalizationEntry(() -> ((Item)SFMItems.DISK_ITEM.get()).m_5524_() + ".tooltip.label_section.header", () -> "Labels");
        public static final LocalizationEntry DISK_ITEM_TOOLTIP_LABEL = new LocalizationEntry(() -> ((Item)SFMItems.DISK_ITEM.get()).m_5524_() + ".tooltip.label_section.entry", () -> " - %s: %d blocks");
        public static LocalizationEntry LABEL_GUN_ITEM = new LocalizationEntry(() -> ((Item)SFMItems.LABEL_GUN_ITEM.get()).m_5524_(), () -> "Label Gun");
        public static final LocalizationEntry LABEL_GUN_CHAT_PULLED = new LocalizationEntry(() -> ((Item)SFMItems.LABEL_GUN_ITEM.get()).m_5524_() + ".chat.pulled", () -> "Pulled labels from the manager.");
        public static final LocalizationEntry LABEL_GUN_CHAT_PUSHED = new LocalizationEntry(() -> ((Item)SFMItems.LABEL_GUN_ITEM.get()).m_5524_() + ".chat.pushed", () -> "Pushed labels to the manager.");
        public static final LocalizationEntry LABEL_GUN_ITEM_TOOLTIP_1 = new LocalizationEntry(() -> ((Item)SFMItems.LABEL_GUN_ITEM.get()).m_5524_() + ".tooltip.1", () -> "Right click a Factory Manager to push labels.");
        public static final LocalizationEntry LABEL_GUN_ITEM_TOOLTIP_2 = new LocalizationEntry(() -> ((Item)SFMItems.LABEL_GUN_ITEM.get()).m_5524_() + ".tooltip.2", () -> "Right click a Factory Manager while sneaking to pull labels.");
        public static final LocalizationEntry LABEL_GUN_ITEM_NAME_WITH_LABEL = new LocalizationEntry(() -> ((Item)SFMItems.LABEL_GUN_ITEM.get()).m_5524_() + ".with_label", () -> "Label Gun: \"%s\"");
        public static final LocalizationEntry WATER_TANK_ITEM_TOOLTIP_1 = new LocalizationEntry(() -> ((Block)SFMBlocks.WATER_TANK_BLOCK.get()).m_7705_() + ".tooltip.1", () -> "Requires two adjacent water sources");
        public static final LocalizationEntry WATER_TANK_ITEM_TOOLTIP_2 = new LocalizationEntry(() -> ((Block)SFMBlocks.WATER_TANK_BLOCK.get()).m_7705_() + ".tooltip.2", () -> "More effective when also adjacent to other water tanks");
        public static final LocalizationEntry LABEL_GUN_GUI_TITLE = new LocalizationEntry("gui.sfm.title.labelgun", "Label Gun");
        public static final LocalizationEntry PROGRAM_TEMPLATE_PICKER_GUI_WARNING_1 = new LocalizationEntry("gui.sfm.program_template_picker.warning1", "Hitting \"Done\" will on the next screen will overwrite your existing program!");
        public static final LocalizationEntry PROGRAM_TEMPLATE_PICKER_GUI_WARNING_2 = new LocalizationEntry("gui.sfm.program_template_picker.warning2", "Hit <esc> to cancel instead.");
        public static final LocalizationEntry PROGRAM_TEMPLATE_PICKER_GUI_TITLE = new LocalizationEntry("gui.sfm.title.program_template_picker", "Program Template Picker");
        public static final LocalizationEntry LABEL_GUN_GUI_LABEL_PLACEHOLDER = new LocalizationEntry("gui.sfm.label_gun.placeholder", "Label");
        public static final LocalizationEntry LABEL_GUN_GUI_LABEL_BUTTON = new LocalizationEntry("gui.sfm.label_gun.label_button", "%s (%d)");
        public static final LocalizationEntry LABEL_GUN_GUI_PRUNE_BUTTON = new LocalizationEntry("gui.sfm.label_gun.prune_button", "Prune");
        public static final LocalizationEntry LABEL_GUN_GUI_CLEAR_BUTTON = new LocalizationEntry("gui.sfm.label_gun.clear_button", "Clear");
        public static final LocalizationEntry MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON_TOOLTIP = new LocalizationEntry("gui.sfm.manager.tooltip.paste", "Press Ctrl+V to paste.");
        public static final LocalizationEntry MANAGER_GUI_EDIT_BUTTON_TOOLTIP = new LocalizationEntry("gui.sfm.manager.edit_button.tooltip", "Press Ctrl+E to edit.");
        public static final LocalizationEntry MANAGER_GUI_EDIT_BUTTON = new LocalizationEntry("gui.sfm.manager.edit_button", "Edit");
        public static final LocalizationEntry MANAGER_RESET_BUTTON_TOOLTIP = new LocalizationEntry("gui.sfm.manager.tooltip.reset", "Wipes ALL disk data.");
        public static final LocalizationEntry MANAGER_CONTAINER = new LocalizationEntry("container.sfm.manager", "Factory Manager");
        public static final LocalizationEntry PROGRAM_WARNING_UNUSED_LABEL = new LocalizationEntry("program.sfm.warnings.unused_label", "Label \"%s\" is used in code but not assigned in the world.");
        public static final LocalizationEntry PROGRAM_WARNING_UNKNOWN_RESOURCE_TYPE = new LocalizationEntry("program.sfm.warnings.unknown_resource_type", "The resource type \"%s\" in \"%s\" is not supported.");
        public static final LocalizationEntry PROGRAM_WARNING_UNKNOWN_RESOURCE_ID = new LocalizationEntry("program.sfm.warnings.unknown_resource_id", "Resource \"%s\" was not found.");
        public static final LocalizationEntry PROGRAM_WARNING_UNDEFINED_LABEL = new LocalizationEntry("program.sfm.warnings.undefined_label", "Label \"%s\" is assigned in the world but not defined in code.");
        public static final LocalizationEntry PROGRAM_WARNING_DISCONNECTED_LABEL = new LocalizationEntry("program.sfm.warnings.disconnected_label", "Label \"%s\" is assigned in the world at %s but not connected by cables.");
        public static final LocalizationEntry PROGRAM_WARNING_ADJACENT_BUT_DISCONNECTED_LABEL = new LocalizationEntry("program.sfm.warnings.adjacent_but_disconnected_label", "Label \"%s\" is assigned in the world at %s and is connected by cables but is not detected as a valid inventory.");
        public static final LocalizationEntry PROGRAM_ERROR_COMPILE_FAILED = new LocalizationEntry("program.sfm.error.compile_failed", "Failed to compile.");
        public static final LocalizationEntry PROGRAM_ERROR_LITERAL = new LocalizationEntry("program.sfm.error.literal", "%s");
        public static final LocalizationEntry PROGRAM_ERROR_MALFORMED_RESOURCE_TYPE = new LocalizationEntry("program.sfm.error.malformed_resource_type", "Program has a malformed resource type \"%s\".\nReminder: Resource types must be literals, not wildcards.");
        public static final LocalizationEntry MANAGER_GUI_STATE_NO_PROGRAM = new LocalizationEntry("gui.sfm.manager.state.no_program", "no program");
        public static final LocalizationEntry MANAGER_GUI_STATE = new LocalizationEntry("gui.sfm.manager.state", "State: %s");
        public static final LocalizationEntry CONTAINER_INSPECTOR_SHOW_EXPORTS_BUTTON = new LocalizationEntry("gui.sfm.container_inspector.show_exports_button", "Export Inspector");
        public static final LocalizationEntry CONTAINER_INSPECTOR_MEKANISM_NULL_DIRECTION_WARNING = new LocalizationEntry("gui.sfm.container_inspector.mekanism_null_direction_warning", "MEKANISM BLOCKS ARE READ-ONLY FROM THE NULL DIRECTION!!!!!!");
        public static final LocalizationEntry CONTAINER_INSPECTOR_MEKANISM_MACHINE_INPUTS = new LocalizationEntry("gui.sfm.container_inspector.mekanism_machine_inputs", "The following are based on the MACHINE'S input config");
        public static final LocalizationEntry CONTAINER_INSPECTOR_MEKANISM_MACHINE_OUTPUTS = new LocalizationEntry("gui.sfm.container_inspector.mekanism_machine_outputs", "The following are based on the MACHINE'S output config");
        public static final LocalizationEntry CONTAINER_INSPECTOR_CONTAINER_SLOT_COUNT = new LocalizationEntry("gui.sfm.container_inspector.container_slot_count", "Container Slots: %d");
        public static final LocalizationEntry CONTAINER_INSPECTOR_INVENTORY_SLOT_COUNT = new LocalizationEntry("gui.sfm.container_inspector.inventory_slot_count", "Inventory Slots: %d");
        public static final LocalizationEntry MANAGER_GUI_PEAK_TICK_TIME = new LocalizationEntry("gui.sfm.manager.peak_tick_time", "Peak tick time: %s ns");
        public static final LocalizationEntry MANAGER_GUI_HOVERED_TICK_TIME = new LocalizationEntry("gui.sfm.manager.hovered_tick_time", "Hovered tick time: %s ns");
        public static final LocalizationEntry MANAGER_GUI_STATE_NO_DISK = new LocalizationEntry("gui.sfm.manager.state.no_disk", "missing disk");
        public static final LocalizationEntry MANAGER_GUI_STATE_RUNNING = new LocalizationEntry("gui.sfm.manager.state.running", "running");
        public static final LocalizationEntry MANAGER_GUI_STATE_INVALID_PROGRAM = new LocalizationEntry("gui.sfm.manager.state.invalid_program", "invalid program");
        public static final LocalizationEntry MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON = new LocalizationEntry("gui.sfm.manager.button.paste_clipboard", "Paste from clipboard");
        public static final LocalizationEntry MANAGER_GUI_COPY_TO_CLIPBOARD_BUTTON = new LocalizationEntry("gui.sfm.manager.button.copy_to_clipboard", "Copy to clipboard");
        public static final LocalizationEntry MANAGER_GUI_VIEW_EXAMPLES_BUTTON = new LocalizationEntry("gui.sfm.manager.button.view_examples", "View examples");
        public static final LocalizationEntry MANAGER_GUI_VIEW_EXAMPLES_BUTTON_TOOLTIP = new LocalizationEntry("gui.sfm.manager.button.view_examples.tooltip", "Press Ctrl+Shift+E to view examples.");
        public static final LocalizationEntry MANAGER_GUI_RESET_BUTTON = new LocalizationEntry("gui.sfm.manager.button.reset", "Reset");
        public static final LocalizationEntry MANAGER_GUI_WARNING_BUTTON_TOOLTIP = new LocalizationEntry("gui.sfm.manager.button.warning.tooltip", "Click to copy code with warnings and errors.\nShift-click to attempt to fix warnings.");
        public static final LocalizationEntry MANAGER_GUI_WARNING_BUTTON_TOOLTIP_READ_ONLY = new LocalizationEntry("gui.sfm.manager.button.warning.tooltip.read_only", "Click to copy code with warnings and errors.");
        public static final LocalizationEntry MANAGER_GUI_STATUS_LOADED_CLIPBOARD = new LocalizationEntry("gui.sfm.manager.status.loaded_clipboard", "Loaded from clipboard!");
        public static final LocalizationEntry MANAGER_GUI_STATUS_SAVED_CLIPBOARD = new LocalizationEntry("gui.sfm.manager.status.saved_clipboard", "Saved to clipboard!");
        public static final LocalizationEntry MANAGER_GUI_STATUS_RESET = new LocalizationEntry("gui.sfm.manager.status.reset", "Reset program and labels!");
        public static final LocalizationEntry MANAGER_GUI_STATUS_FIX = new LocalizationEntry("gui.sfm.manager.status.fix", "Cleaning up labels!");
        public static final LocalizationEntry GUI_ADVANCED_TOOLTIP_HINT = new LocalizationEntry("gui.sfm.advanced.tooltip.hint", ChatFormatting.GRAY + "Hold " + ChatFormatting.AQUA + "%s" + ChatFormatting.GRAY + " for more info");
        public static final LocalizationEntry MORE_HOVER_INFO_KEY = new LocalizationEntry("key.sfm.more_info", "Show More Item Hover Info");
        public static final LocalizationEntry CONTAINER_INSPECTOR_TOGGLE_KEY = new LocalizationEntry("key.sfm.container_inspector.activation_key", "Toggle Container Inspector");
        public static final LocalizationEntry SFM_KEY_CATEGORY = new LocalizationEntry("key.categories.sfm", "Super Factory Manager");

        public static List<LocalizationEntry> getEntries() {
            ArrayList<LocalizationEntry> rtn = new ArrayList<LocalizationEntry>();
            for (Field field : LocalizationKeys.class.getFields()) {
                if (field.getType() != LocalizationEntry.class) continue;
                try {
                    rtn.add((LocalizationEntry)field.get(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return rtn;
        }

        public record LocalizationEntry(Supplier<String> key, Supplier<String> value) {
            public LocalizationEntry(String key, String value) {
                this(() -> key, () -> value);
            }

            public TranslatableContents get(Object ... args) {
                return new TranslatableContents(this.key.get(), args);
            }

            public TranslatableContents get() {
                return new TranslatableContents(this.key.get());
            }

            public String getString() {
                return I18n.m_118938_((String)this.key.get(), (Object[])new Object[0]);
            }

            public String getString(Object ... args) {
                return I18n.m_118938_((String)this.key.get(), (Object[])args);
            }

            public MutableComponent getComponent() {
                return Component.m_237115_((String)this.key.get());
            }

            public MutableComponent getComponent(Object ... args) {
                return Component.m_237110_((String)this.key.get(), (Object[])args);
            }
        }
    }
}

