/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.monorail;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackPropagator;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MonorailTrackBlock
extends TrackBlock {
    public MonorailTrackBlock(BlockBehaviour.Properties properties, TrackMaterial material) {
        super(properties, material);
    }

    public BlockState getBogeyAnchor(BlockGetter world, BlockPos pos, BlockState state) {
        return (BlockState)CRBlocks.MONO_BOGEY.getDefaultState().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)(state.m_61143_((Property)SHAPE) == TrackShape.XO ? Direction.Axis.X : Direction.Axis.Z));
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((TrackShape)pState.m_61143_((Property)SHAPE)) {
            case TrackShape.AE, TrackShape.AW, TrackShape.AN, TrackShape.AS -> Shapes.m_83040_();
            default -> CRShapes.MONORAIL_COLLISION;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getFullShape(state);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter pLevel, BlockPos pPos) {
        return this.getFullShape(state);
    }

    private VoxelShape getFullShape(BlockState state) {
        switch ((TrackShape)state.m_61143_((Property)SHAPE)) {
            case AE: {
                return CRShapes.MONORAIL_TRACK_ASC.get(Direction.EAST);
            }
            case AW: {
                return CRShapes.MONORAIL_TRACK_ASC.get(Direction.WEST);
            }
            case AN: {
                return CRShapes.MONORAIL_TRACK_ASC.get(Direction.NORTH);
            }
            case AS: {
                return CRShapes.MONORAIL_TRACK_ASC.get(Direction.SOUTH);
            }
            case CR_D: {
                return CRShapes.MONORAIL_TRACK_CROSS_DIAG;
            }
            case CR_NDX: {
                return CRShapes.MONORAIL_TRACK_CROSS_ORTHO_DIAG.get(Direction.SOUTH);
            }
            case CR_NDZ: {
                return CRShapes.MONORAIL_TRACK_CROSS_DIAG_ORTHO.get(Direction.SOUTH);
            }
            case CR_O: {
                return CRShapes.MONORAIL_TRACK_CROSS;
            }
            case CR_PDX: {
                return CRShapes.MONORAIL_TRACK_CROSS_DIAG_ORTHO.get(Direction.EAST);
            }
            case CR_PDZ: {
                return CRShapes.MONORAIL_TRACK_CROSS_ORTHO_DIAG.get(Direction.EAST);
            }
            case ND: {
                return CRShapes.MONORAIL_TRACK_DIAG.get(Direction.SOUTH);
            }
            case PD: {
                return CRShapes.MONORAIL_TRACK_DIAG.get(Direction.EAST);
            }
            case XO: {
                return CRShapes.MONORAIL_TRACK_ORTHO.get(Direction.EAST);
            }
            case ZO: {
                return CRShapes.MONORAIL_TRACK_ORTHO.get(Direction.SOUTH);
            }
            case TE: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(Direction.EAST);
            }
            case TW: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(Direction.WEST);
            }
            case TS: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(Direction.SOUTH);
            }
            case TN: {
                return CRShapes.MONORAIL_TRACK_ORTHO_LONG.get(Direction.NORTH);
            }
        }
        return CRShapes.MONORAIL_TRACK_FALLBACK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel prepareAssemblyOverlay(BlockGetter world, BlockPos pos, BlockState state, Direction direction, PoseStack ms) {
        ((TransformStack)TransformStack.cast((PoseStack)ms).rotateCentered(Direction.UP, AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)direction)))).translateY(0.875);
        return CRBlockPartials.MONORAIL_TRACK_ASSEMBLING_OVERLAY;
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!state.m_61138_((Property)SHAPE)) {
            return;
        }
        TrackGraphLocation location = TrackGraphHelper.getGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Vec3)((Vec3)((TrackShape)state.m_61143_((Property)SHAPE)).getAxes().get(0)));
        if (location == null) {
            return;
        }
        Couple nodes = location.edge.map(e -> location.graph.locateNode(e));
        if (nodes.either(Objects::isNull)) {
            return;
        }
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        if (edge.getTrackMaterial() != this.getMaterial()) {
            TrackPropagator.onRailAdded((LevelAccessor)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, world, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        if (!world.f_46443_ && AllItems.BRASS_HAND.isIn(player.m_21120_(hand))) {
            TrackPropagator.onRailAdded((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
            return InteractionResult.SUCCESS;
        }
        return result;
    }
}

