/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.datafixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class UpsideDownMonoBogeyFix
extends DataFix {
    private final String name;

    public UpsideDownMonoBogeyFix(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.name = name;
    }

    public TypeRewriteRule makeRule() {
        Type type2;
        Type type = this.getInputSchema().getType(References.f_16787_);
        if (!Objects.equals(type, type2 = DSL.named((String)References.f_16787_.typeName(), (Type)NamespacedSchema.m_17310_()))) {
            throw new IllegalStateException("block type is not what was expected.");
        }
        TypeRewriteRule typeRewriteRule = this.fixTypeEverywhere(this.name + " for block", type2, dynamicOps -> pair -> pair.mapSecond(this::fixBlock));
        TypeRewriteRule typeRewriteRule2 = this.fixTypeEverywhereTyped(this.name + " for block_state", this.getInputSchema().getType(References.f_16783_), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("Name").asString().result();
            if (optional.isPresent() && ((String)optional.get()).equals("railways:mono_bogey_upside_down")) {
                dynamic = dynamic.set("Name", dynamic.createString("railways:mono_bogey"));
                Dynamic properties = dynamic.get("Properties").orElseEmptyMap().set("upside_down", dynamic.createString("true"));
                dynamic = dynamic.set("Properties", properties);
                return dynamic;
            }
            return dynamic;
        }));
        return TypeRewriteRule.seq((TypeRewriteRule)typeRewriteRule, (TypeRewriteRule)typeRewriteRule2);
    }

    private String fixBlock(String original) {
        if (original.equals("railways:mono_bogey_upside_down")) {
            return "railways:mono_bogey";
        }
        return original;
    }
}

