/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class TargetOrRetaliate<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148194_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.REGISTERED)});
    protected Predicate<LivingEntity> canAttackPredicate = entity -> {
        Player player;
        return entity.m_6084_() && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_());
    };
    protected BiPredicate<E, Entity> alertAlliesPredicate = (owner, attacker) -> false;
    protected BiPredicate<E, LivingEntity> allyPredicate = (owner, ally) -> {
        TamableAnimal pet;
        return owner.getClass().isAssignableFrom(ally.getClass()) && BrainUtils.getTargetOfEntity(ally) == null && (!(owner instanceof TamableAnimal) || (pet = (TamableAnimal)owner).m_21826_() == ((TamableAnimal)ally).m_21826_()) && !ally.m_7307_((Entity)BrainUtils.getMemory(ally, MemoryModuleType.f_26382_));
    };
    protected LivingEntity toTarget = null;
    protected MemoryModuleType<? extends LivingEntity> priorityTargetMemory = MemoryModuleType.f_148194_;

    public TargetOrRetaliate<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> useMemory(MemoryModuleType<? extends LivingEntity> memory) {
        this.priorityTargetMemory = memory;
        return this;
    }

    public TargetOrRetaliate<E> alertAlliesWhen(BiPredicate<E, Entity> predicate) {
        this.alertAlliesPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> isAllyIf(BiPredicate<E, LivingEntity> predicate) {
        this.allyPredicate = predicate;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        Brain brain = owner.m_6274_();
        this.toTarget = BrainUtils.getMemory(brain, this.priorityTargetMemory);
        if (this.toTarget == null) {
            this.toTarget = (LivingEntity)BrainUtils.getMemory(brain, MemoryModuleType.f_26382_);
            if (this.toTarget != null && this.canAttackPredicate.test(this.toTarget)) {
                if (this.alertAlliesPredicate.test(owner, (Entity)this.toTarget)) {
                    this.alertAllies(level, owner);
                }
                return true;
            }
            NearestVisibleLivingEntities nearbyEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(brain, MemoryModuleType.f_148205_);
            if (nearbyEntities != null) {
                this.toTarget = nearbyEntities.m_186116_(this.canAttackPredicate).orElse(null);
            }
            return this.toTarget != null && this.canAttackPredicate.test(this.toTarget);
        }
        return this.canAttackPredicate.test(this.toTarget);
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, MemoryModuleType.f_26326_);
        this.toTarget = null;
    }

    protected void alertAllies(ServerLevel level, E owner) {
        double followRange = owner.m_21133_(Attributes.f_22277_);
        for (LivingEntity ally : EntityRetrievalUtil.getEntities((Level)level, owner.m_20191_().m_82377_(followRange, 10.0, followRange), entity -> {
            LivingEntity livingEntity;
            return entity != owner && entity instanceof LivingEntity && this.allyPredicate.test(owner, livingEntity = (LivingEntity)entity);
        })) {
            BrainUtils.setTargetOfEntity(ally, this.toTarget);
        }
    }
}

