/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CommentedCodec;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import potionstudios.byg.BYG;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.util.ModPlatform;

public record BiomepediaConfig(boolean biomepediaInventoryButtonEnabled, boolean giveBiomepediaBook) {
    public static final Codec<BiomepediaConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CommentedCodec.of((Codec)Codec.BOOL, (String)"inventory_enabled", (String)"Whether the biomepedia inventory BUTTON is enabled or not in the player inventory for all users connected to this host.").forGetter(BiomepediaConfig::biomepediaInventoryButtonEnabled), (App)CommentedCodec.of((Codec)Codec.BOOL, (String)"give_item", (String)"Whether to give the biomepedia book ITEM to new players for the first time.").orElse((Object)true).forGetter(BiomepediaConfig::giveBiomepediaBook)).apply((Applicative)builder, BiomepediaConfig::new));
    public static final BiomepediaConfig DEFAULT = new BiomepediaConfig(true, true);
    public static BiomepediaConfig INSTANCE = null;

    public static BiomepediaConfig getConfig() {
        return BiomepediaConfig.getConfig(false, false);
    }

    public static BiomepediaConfig getConfig(boolean serialize) {
        return BiomepediaConfig.getConfig(serialize, false);
    }

    public static BiomepediaConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = BiomepediaConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    private static BiomepediaConfig readConfig(boolean recreate) {
        Path path = ModPlatform.INSTANCE.configPath().resolve("biomepedia.json5");
        if (!path.toFile().exists() || recreate) {
            JanksonUtil.createConfig((Path)path, CODEC, (String)"/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map)((Map)Util.m_137469_(new HashMap(), map -> map.put("inventory_enabled", ""))), (DynamicOps)JanksonJsonOps.INSTANCE, (Object)DEFAULT);
        }
        BYG.logInfo(String.format("\"%s\" was read.", path.toString()));
        try {
            return (BiomepediaConfig)JanksonUtil.readConfig((Path)path, CODEC, (DynamicOps)JanksonJsonOps.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            BYGConfigHandler.CONFIG_EXCEPTIONS.add(e);
            return DEFAULT;
        }
    }
}

