/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.volcano;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.stateproviders.BetweenNoiseThresholdProvider;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;
import potionstudios.byg.common.world.structure.BYGStructurePieceTypes;
import potionstudios.byg.common.world.structure.volcano.VolcanoStructure;

public class VolcanoPiece
extends StructurePiece {
    private final VolcanoStructure.PieceStructureInfo structureInfo;

    protected VolcanoPiece(VolcanoStructure.PieceStructureInfo structureInfo, int genDepth, BoundingBox boundingBox) {
        super(BYGStructurePieceTypes.VOLCANO_PIECE.get(), genDepth, boundingBox);
        this.structureInfo = structureInfo;
    }

    public VolcanoPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BYGStructurePieceTypes.ARCH_PIECE.get(), tag);
        this.structureInfo = (VolcanoStructure.PieceStructureInfo)((Pair)VolcanoStructure.PieceStructureInfo.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("volcano_info")).result().orElseThrow()).getFirst();
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        compoundTag.m_128365_("volcano_info", (Tag)VolcanoStructure.PieceStructureInfo.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.structureInfo).result().orElseThrow());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        BetweenNoiseThresholdProvider weightedBlockStateProvider = new BetweenNoiseThresholdProvider(123L, new NormalNoise.NoiseParameters(-9, 1.0, new double[]{1.0, 1.0, 1.0}), 1.0f, List.of(UniformFloat.m_146605_((float)-0.90449995f, (float)-0.8955f), UniformFloat.m_146605_((float)-0.0045f, (float)0.0045f)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50450_), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50137_.m_49966_(), 9).m_146271_((Object)BYGBlocks.BLACK_SAND.defaultBlockState(), 2).m_146271_((Object)Blocks.f_152550_.m_49966_(), 5).m_146271_((Object)Blocks.f_152597_.m_49966_(), 10).m_146270_()), false);
        double baseRadius = this.structureInfo.baseRadius();
        double leakage = this.structureInfo.leakage();
        int volcanoConeSize = this.structureInfo.volcanoConeSize();
        int volcanoStartHeight = this.structureInfo.volcanoStartHeight();
        double threshold = 0.35;
        int maxY = this.structureInfo.maxY();
        int baseHeight = this.structureInfo.origin().m_123342_();
        int fluidYOffset = this.structureInfo.fluidY();
        FastNoiseLite fastNoiseLite = FastNoiseLite.createSpongePerlin(this.structureInfo.noiseSeed());
        fastNoiseLite.SetFrequency(0.05f);
        BlockPos subtract = this.structureInfo.origin().m_7918_(-volcanoConeSize, 0, -volcanoConeSize);
        int startX = subtract.m_123341_();
        int startZ = subtract.m_123343_();
        BlockPos add = this.structureInfo.origin().m_7918_(volcanoConeSize, 0, volcanoConeSize);
        int endX = add.m_123341_();
        int endZ = add.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int minX = Math.max(startX, chunkPos.m_45604_());
        int maxX = Math.min(endX, chunkPos.m_45608_());
        int minZ = Math.max(startZ, chunkPos.m_45605_());
        int maxZ = Math.min(endZ, chunkPos.m_45609_());
        for (int worldX = minX; worldX <= maxX; ++worldX) {
            int localX = worldX - this.structureInfo.origin().m_123341_();
            for (int worldZ = minZ; worldZ <= maxZ; ++worldZ) {
                int localZ = worldZ - this.structureInfo.origin().m_123343_();
                for (double y = (double)(-volcanoConeSize); y <= (double)maxY; y += 1.0) {
                    mutable.m_122169_((double)worldX, (double)baseHeight + y + (double)volcanoStartHeight, (double)worldZ);
                    float spongePerlinValue = FastNoiseLite.getSpongePerlinValue(fastNoiseLite.GetNoise(mutable.m_123341_(), mutable.m_123343_()));
                    double scaledNoise = (double)(spongePerlinValue / 13.0f) * (-(y * baseRadius) / (double)(localX * localX + localZ * localZ));
                    int fluidY = maxY - fluidYOffset;
                    double lava = scaledNoise - leakage - leakage / 2.0 - 0.5;
                    double crater = scaledNoise - 0.05;
                    if (lava >= threshold) {
                        if (y <= (double)fluidY) {
                            worldGenLevel.m_6933_((BlockPos)mutable, Blocks.f_49991_.m_49966_(), 2, 1);
                        }
                    } else if (crater >= threshold) {
                        double pct = threshold / crater;
                        double craterY = Mth.m_14085_((double)maxY, (double)fluidY, (double)(1.0 - pct));
                        if (y <= craterY) {
                            worldGenLevel.m_6933_((BlockPos)mutable, weightedBlockStateProvider.m_213972_(randomSource, (BlockPos)mutable), 2, 1);
                        }
                    } else if (scaledNoise >= threshold) {
                        worldGenLevel.m_6933_((BlockPos)mutable, weightedBlockStateProvider.m_213972_(randomSource, (BlockPos)mutable), 2, 1);
                    }
                    mutable.m_122173_(Direction.DOWN);
                }
            }
        }
    }
}

