/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.math.noise.worley;

import java.util.Objects;
import java.util.Random;

public class XorShift {
    private static final int SEED_TABLE_SPACE = 1024;
    private static final int SEED_TABLE_SIZE = 3072;
    static Random random;
    private final long[] seeds = new long[3072];

    private XorShift(Random seed) {
        for (int i = 0; i < 3072; ++i) {
            this.seeds[i] = seed.nextLong();
        }
    }

    public static XorShift create() {
        return new XorShift(random);
    }

    public static XorShift create(Random seed) {
        return new XorShift(seed);
    }

    public static long fastAbs(long n) {
        long mask = n >> 63;
        return n + mask ^ mask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XorShift) {
            XorShift o = (XorShift)obj;
            return Objects.equals(this.seeds, o.seeds);
        }
        return false;
    }

    public Instance getInstance() {
        return new Instance();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.seeds});
    }

    public final class Instance {
        private long x;
        private long z;

        private Instance() {
            this.setSeed(0L, 0L);
        }

        public double nextDouble() {
            return (double)(this.nextLong() >>> 2) * 2.168404344971009E-19;
        }

        public long nextLong() {
            long t = this.x ^ this.x << 13;
            this.x = this.z;
            this.z = this.z ^ this.z >>> 3 ^ (t ^ t >>> 19);
            return this.z;
        }

        public void setSeed(long x, long z) {
            this.x = XorShift.this.seeds[(int)(XorShift.fastAbs(x) % 1024L)];
            this.z = XorShift.this.seeds[(int)(XorShift.fastAbs(z) % 1024L) + 1024 + 1024];
        }
    }
}

