/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end.islands.shattered;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class ShatteredFloatingIslands4
extends Feature<FloatingIslandConfig> {
    FastNoise perlin = null;

    public ShatteredFloatingIslands4(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, FloatingIslandConfig config) {
        double z;
        double y;
        double x;
        this.setSeed(world.m_7328_());
        if (world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) > 4) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        double radius = 13.0;
        double size = radius / 3.0;
        double radiusHalved = radius / 2.0;
        for (x = -radius; x <= radius; x += 1.0) {
            for (y = -radius; y <= 1.0; y += 1.0) {
                for (z = -radius; z <= radius; z += 1.0) {
                    double squareNoise1 = this.perlin.GetNoise((float)x, (float)y, (float)z) * 12.0f - 6.0f;
                    double distanceSqt1 = x * x + y * y + z * z + squareNoise1 * squareNoise1;
                    if (!(distanceSqt1 <= radius * radius) || !(y <= 1.0)) continue;
                    world.m_7731_(mutable.m_7637_(x, y, z), config.getTopBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                    if (!(y <= 0.0)) continue;
                    world.m_7731_(mutable.m_7637_(x, y, z), config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                    if (!(y <= -2.0)) continue;
                    world.m_7731_(mutable.m_7637_(x, y, z), config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radiusHalved; x <= radiusHalved; x += 1.0) {
            for (y = -size; y <= size; y += 1.0) {
                for (z = -radiusHalved; z <= radiusHalved; z += 1.0) {
                    double distanceSqt1 = x * x + y * y + z * z;
                    if (!(distanceSqt1 <= radiusHalved * radiusHalved) || !(y <= 2.0)) continue;
                    world.m_7731_(mutable.m_7637_(x, y, z), Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = new FastNoise((int)seed);
            this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

