/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.end.islands;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class FloatingIslands1
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands1(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, FloatingIslandConfig config) {
        this.setSeed(world.m_7328_());
        double radius = 10.0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (double x = -radius; x <= radius; x += 1.0) {
            for (double y = 1.0; y <= radius; y += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)(y - radius), (int)z);
                    double noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    double scaledNoise = noise * (y * 3.0 / (x * x + z * z));
                    if (!(scaledNoise >= 0.5)) continue;
                    if (y == radius) {
                        world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_213972_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (Holder feature : config.getPlacedFeatures()) {
            ((PlacedFeature)feature.m_203334_()).m_226357_(world, generator, rand, pos.m_7494_());
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

