/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import potionstudios.byg.common.BYGCarvableBlocks;
import potionstudios.byg.common.BYGFlammables;
import potionstudios.byg.common.BYGFlattenables;
import potionstudios.byg.common.BYGHoeables;
import potionstudios.byg.common.BYGTags;
import potionstudios.byg.common.block.BYGBlockTags;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.BYGEntities;
import potionstudios.byg.common.entity.ai.village.poi.BYGPoiTypes;
import potionstudios.byg.common.entity.villager.BYGVillagerType;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.mixin.access.BlockEntityTypeAccess;
import potionstudios.byg.mixin.access.DeltaFeatureAccess;
import potionstudios.byg.mixin.access.PoiTypesAccess;
import potionstudios.byg.reg.BlockRegistryObject;
import potionstudios.byg.server.command.ReloadConfigsCommand;
import potionstudios.byg.server.command.ResetConfigsCommand;
import potionstudios.byg.server.command.UpdateConfigsCommand;
import potionstudios.byg.server.command.ValidateConfigsCommand;
import potionstudios.byg.util.FileUtils;
import potionstudios.byg.util.MLBlockTags;
import potionstudios.byg.util.ModPlatform;

public class BYG {
    public static final String MOD_ID = "byg";
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean INITIALIZED;
    private static final Map<Block, Predicate<BlockBehaviour.BlockStateBase>> BLOCKSTATE_IS_REPLACEMENTS;

    public static void commonLoad() {
        BYG.registerBlockTagReplacements();
        PoiTypesAccess.byg_invokeRegisterBlockStates(BYGPoiTypes.FORAGER.asHolder());
        String loadAllConfigs = BYGConfigHandler.loadAllConfigs(false, false);
        BYG.logConfigErrors();
        BYGEntities.registerSpawnPlacements();
        FileUtils.backUpDirectory(ModPlatform.INSTANCE.configPath(), "last_working_configs_backup");
        if (Boolean.getBoolean("bygDev")) {
            ModPlatform.INSTANCE.addTagsUpdatedListener(access -> {
                for (BYGTags tag : BYGTags.values()) {
                    for (BYGTags.RegistryType<?> allowed : tag.acceptedTypes) {
                        TagKey<?> bygTag;
                        Optional<HolderSet.Named<?>> holder = allowed.getTag(bygTag = tag.byg(allowed));
                        if (!holder.isEmpty() && !holder.get().m_203614_().findFirst().isEmpty()) continue;
                        BYG.logWarning("Tag %s of type %s is empty!".formatted(bygTag.f_203868_(), allowed.registry.m_135782_()));
                    }
                }
            });
        }
    }

    private static void registerBlockTagReplacements() {
        BYG.blockToBlockTagReplacement(Blocks.f_50078_, MLBlockTags.BOOKSHELVES);
        BYG.blockToBlockTagReplacement(Blocks.f_50093_, BYGBlockTags.FARMLAND);
        BYG.blockToBlockTagReplacement(Blocks.f_50259_, BYGBlockTags.END_STONE);
    }

    public static void blockToBlockTagReplacement(Block block, TagKey<Block> blockTag) {
        BLOCKSTATE_IS_REPLACEMENTS.put(block, state -> state.m_204336_(blockTag));
    }

    public static void blockToInstanceOfReplacement(Block block, Class<? extends Block> clazz) {
        BLOCKSTATE_IS_REPLACEMENTS.put(block, state -> clazz.isInstance(state.m_60734_()));
    }

    public static Map<Block, Predicate<BlockBehaviour.BlockStateBase>> getBlockstateIsReplacements() {
        return BLOCKSTATE_IS_REPLACEMENTS;
    }

    public static void attachCommands(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environmentType) {
        LiteralArgumentBuilder bygCommands = Commands.m_82127_((String)MOD_ID);
        LiteralArgumentBuilder config = Commands.m_82127_((String)"config");
        config.then(ReloadConfigsCommand.register());
        config.then(UpdateConfigsCommand.register());
        config.then(ValidateConfigsCommand.register());
        config.then(ResetConfigsCommand.register());
        bygCommands.then((ArgumentBuilder)config);
        dispatcher.register(bygCommands);
    }

    public static void threadSafeCommonLoad() {
        BYGVillagerType.setVillagerForBYGBiomes();
        BYG.appendBlocksToBlockEntities();
        DeltaFeatureAccess.byg_setCANNOT_REPLACE((ImmutableList<Block>)new ImmutableList.Builder().addAll(DeltaFeatureAccess.byg_getCANNOT_REPLACE()).add((Object)((Block)BYGBlocks.EMBUR_GEL_BLOCK.get())).add((Object)((Block)BYGBlocks.EMBUR_GEL_BRANCH.get())).add((Object)((Block)BYGBlocks.EMBUR_GEL_VINES.get())).addAll((Iterable)Util.m_137469_(new ArrayList(), list -> {
            for (Block block : Registry.f_122824_) {
                Material material = block.m_49966_().m_60767_();
                if (material != Material.f_76300_ && material != Material.f_76271_ && material != Material.f_76270_ && material != Material.f_76302_ && material != Material.f_76303_ && material != Material.f_76304_ && material != Material.f_76274_ && material != Material.f_76320_) continue;
                list.add(block);
            }
        })).build());
    }

    private static void appendBlocksToBlockEntities() {
        BlockEntityTypeAccess campfireBuilderAccess = (BlockEntityTypeAccess)BlockEntityType.f_58911_;
        ObjectOpenHashSet validCampfireBlocks = new ObjectOpenHashSet(campfireBuilderAccess.byg_getValidBlocks());
        validCampfireBlocks.add((Block)BYGBlocks.CRYPTIC_CAMPFIRE.get());
        validCampfireBlocks.add((Block)BYGBlocks.BORIC_CAMPFIRE.get());
        campfireBuilderAccess.byg_setValidBlocks((Set<Block>)validCampfireBlocks);
        BlockEntityTypeAccess signBuilderAccess = (BlockEntityTypeAccess)BlockEntityType.f_58924_;
        ObjectOpenHashSet signValidBlocks = new ObjectOpenHashSet(signBuilderAccess.byg_getValidBlocks());
        for (BlockRegistryObject<Block> signBlock : BYGBlocks.SIGN_BLOCKS) {
            Block block = (Block)signBlock.get();
            if (block instanceof SignBlock) {
                signValidBlocks.add(block);
                continue;
            }
            throw new IllegalArgumentException("Attempting to add block to sign block entity that is not a type of SignBlock");
        }
        signBuilderAccess.byg_setValidBlocks((Set<Block>)signValidBlocks);
    }

    public static void threadSafeLoadFinish() {
        BYG.logDebug("BYG: \"Load Complete Event\" Starting...");
        BYGHoeables.tillablesBYG();
        BYGFlammables.flammablesBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGFlattenables.addFlattenables();
        BYG.logDebug("BYG: \"Load Complete\" Event Complete!");
    }

    public static ResourceLocation createLocation(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ResourceLocation createLocation(ResourceKey<?> path) {
        return path.m_135782_();
    }

    public static ResourceLocation createLocation(Holder<?> holder) {
        return BYG.createLocation((ResourceKey)holder.m_203543_().orElseThrow());
    }

    public static void logWarning(String msg) {
        SettingsConfig.LoggerSettings loggerSettings = SettingsConfig.getConfig().loggerSettings();
        if (loggerSettings.logWarnings()) {
            if (loggerSettings.exclude().stream().noneMatch(msg::contains)) {
                LOGGER.warn(msg);
            }
        }
    }

    public static void logInfo(String msg) {
        SettingsConfig.LoggerSettings loggerSettings = SettingsConfig.getConfig().loggerSettings();
        if (loggerSettings.logInfo()) {
            if (loggerSettings.exclude().stream().noneMatch(msg::contains)) {
                LOGGER.info(msg);
            }
        }
    }

    public static void logDebug(String msg) {
        SettingsConfig.LoggerSettings loggerSettings = SettingsConfig.getConfig().loggerSettings();
        if (loggerSettings.logDebug()) {
            if (loggerSettings.exclude().stream().noneMatch(msg::contains)) {
                LOGGER.debug(msg);
            }
        }
    }

    public static void logError(String msg) {
        LOGGER.error(msg);
    }

    public static void logConfigErrors() {
        if (!BYGConfigHandler.CONFIG_EXCEPTIONS.isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                BYG.logError("");
            }
            BYG.logError("=".repeat(100));
            BYG.logError("");
            BYG.logError("BYG config(s) errors have occurred, BYG has used default settings instead! Errors:");
            BYG.logError("");
            int count = 0;
            for (Exception e : BYGConfigHandler.CONFIG_EXCEPTIONS) {
                BYG.logError(count + ". " + e.getMessage());
                BYG.logError("");
                ++count;
            }
            BYG.logError("");
            BYG.logError("This error goes away after you fix or delete your configs and you restart your game.");
            BYG.logError("");
            BYG.logError("=".repeat(100));
            for (int i = 0; i < 3; ++i) {
                BYG.logError("");
            }
        }
    }

    static {
        BLOCKSTATE_IS_REPLACEMENTS = new HashMap<Block, Predicate<BlockBehaviour.BlockStateBase>>();
        ConfigVersionTracker.getConfig(new ConfigVersionTracker(ModPlatform.INSTANCE.configPath().toFile().exists() ? 0 : 6), false);
    }
}

