/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.gui;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.NoChatReportsClient;
import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerSafetyState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AwaitConnectionScreen
extends Screen {
    private final Screen parent;
    private boolean aborted = false;
    private long millisAwaiting = 0L;

    public AwaitConnectionScreen(Screen parent) {
        super(GameNarrator.f_93310_);
        this.parent = parent;
    }

    protected void m_7856_() {
        this.m_169413_();
        this.millisAwaiting = Util.m_137550_();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120 + 12, 200, 20, CommonComponents.f_130656_, button -> {
            if (NCRConfig.getCommon().enableDebugLog()) {
                NoChatReports.LOGGER.info("Aborted reconnect await!");
            }
            this.aborted = true;
            this.f_96541_.m_91152_(this.parent);
            ServerSafetyState.reset();
        }));
    }

    public void m_86600_() {
        if (!this.aborted && this.getRemainingTime() <= 0L) {
            this.aborted = true;
            NoChatReportsClient.reconnectLastServer();
        }
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_7333_(poseStack);
        MutableComponent status = Component.m_237110_((String)"nochatreports.connect.await", (Object[])new Object[]{this.getRemainingTime() / 1000L});
        ConnectScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"nochatreports.connect.nokey_rejected"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 50), (int)0xFFFFFF);
        ConnectScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)status, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 36), (int)0xFFFFFF);
        super.m_6305_(poseStack, i, j, f);
    }

    private long getRemainingTime() {
        long disconnect;
        long current = Util.m_137550_();
        if (current - (disconnect = ServerSafetyState.getDisconnectMillis()) <= this.getDisconnectAwaitTime() + 100L) {
            return this.getDisconnectAwaitTime() - (current - disconnect);
        }
        return this.getAwaitTime() - (current - this.millisAwaiting);
    }

    private long getDisconnectAwaitTime() {
        return (long)NCRConfig.getClient().getPostDisconnectAwaitSeconds() * 1000L;
    }

    private long getAwaitTime() {
        return (long)NCRConfig.getClient().getReconnectAwaitSeconds() * 1000L;
    }
}

