/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEffectInhibitor
extends EntityRenderer<EntityEffectInhibitor> {
    private final Map<ResourceLocation, ItemStack> items = new HashMap<ResourceLocation, ItemStack>();

    public RenderEffectInhibitor(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(EntityEffectInhibitor entity) {
        return InventoryMenu.f_39692_;
    }

    public void render(EntityEffectInhibitor entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float time = (float)(entity.renderTicks + entity.m_19879_()) + partialTicks;
        float bob = (float)Math.sin(time / 10.0f) * 0.05f;
        matrixStackIn.m_85837_(0.0, (double)(0.15f + bob), 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(time * 3.0f % 360.0f));
        ResourceLocation effect = entity.getInhibitedEffect();
        ItemStack stack = this.items.computeIfAbsent(effect, res -> ItemEffectPowder.setEffect(new ItemStack((ItemLike)ModItems.EFFECT_POWDER), effect));
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, packedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 0);
        matrixStackIn.m_85849_();
    }
}

