/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class ExplosionEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "explosions");
    private float strength;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(level, pos, 85);
        if (aura > -5000000) {
            return false;
        }
        int chance = 140 - Math.abs(aura) / 200000;
        if (chance > 1 && level.f_46441_.m_188503_(chance) != 0) {
            return false;
        }
        this.strength = Math.min((float)Math.abs(aura) / 5000000.0f, 5.0f);
        if (this.strength <= 0.0f) {
            return false;
        }
        this.dist = Mth.m_14045_((int)(Math.abs(aura) / 200000), (int)25, (int)100);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.f_19853_, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Blocks.f_50077_);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        int z;
        if (level.m_46467_() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        int x = Mth.m_14107_((double)((double)pos.m_123341_() + level.f_46441_.m_188583_() * (double)this.dist));
        BlockPos chosenPos = new BlockPos(x, level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = Mth.m_14107_((double)((double)pos.m_123343_() + level.f_46441_.m_188583_() * (double)this.dist))), z);
        if (chosenPos.m_123331_((Vec3i)pos) <= (double)(this.dist * this.dist) && level.m_46749_(chosenPos)) {
            level.m_46518_(null, (double)chosenPos.m_123341_() + 0.5, (double)chosenPos.m_123342_() + 0.5, (double)chosenPos.m_123343_() + 0.5, this.strength, false, Explosion.BlockInteraction.DESTROY);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.explosionEffect.get();
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

