/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class BlockEntityHopperUpgrade
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityHopperUpgrade(BlockPos pos, BlockState state) {
        super(ModBlockEntities.HOPPER_UPGRADE, pos, state);
    }

    private static boolean isValidHopper(BlockEntity tile) {
        if (tile instanceof HopperBlockEntity) {
            return (Boolean)tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)HopperBlock.f_54022_);
        }
        if (tile instanceof BlockEntityGratedChute) {
            return ((BlockEntityGratedChute)tile).redstonePower <= 0;
        }
        return false;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 10L == 0L) {
            if (IAuraChunk.getAuraInArea(this.f_58857_, this.f_58858_, 25) < 100000) {
                return;
            }
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (!BlockEntityHopperUpgrade.isValidHopper(tile)) {
                return;
            }
            IItemHandler handler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).orElse(null);
            if (handler == null) {
                return;
            }
            List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(7.0));
            if (items.isEmpty()) {
                return;
            }
            int drainPerItem = 500;
            if (!this.canUseRightNow(drainPerItem * items.size())) {
                return;
            }
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.m_6084_() || item.m_32063_() || (stack = item.m_32055_()).m_41619_()) continue;
                ItemStack copy = stack.m_41777_();
                for (int i = 0; i < handler.getSlots() && !(copy = handler.insertItem(i, copy, false)).m_41619_(); ++i) {
                }
                if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)copy)) continue;
                item.m_32045_(copy);
                if (copy.m_41619_()) {
                    item.m_6074_();
                }
                BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 25, this.f_58858_);
                IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, drainPerItem);
                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles((float)item.m_20185_(), (float)item.m_20186_(), (float)item.m_20189_(), PacketParticles.Type.HOPPER_UPGRADE, new int[0]));
            }
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

