/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mythicbotany.alftools.AlfsteelPick;
import mythicbotany.register.ModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import vazkii.botania.common.lib.BotaniaTags;

public class AlfsteelDisposeModifier
extends LootModifier {
    public static final Codec<AlfsteelDisposeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions)).apply((Applicative)instance, AlfsteelDisposeModifier::new));

    public AlfsteelDisposeModifier(LootItemCondition ... conditions) {
        super(conditions);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (entity != null && tool != null && !tool.m_41619_()) {
            AlfsteelDisposeModifier.filterDisposable(generatedLoot, entity, tool);
        }
        return generatedLoot;
    }

    public static void filterDisposable(List<ItemStack> drops, Entity entity, ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() == ModItems.alfsteelPick && AlfsteelPick.isTipped((ItemStack)stack)) {
            drops.removeIf(loot -> !loot.m_41619_() && (loot.m_204117_(BotaniaTags.Items.DISPOSABLE) || loot.m_204117_(BotaniaTags.Items.SEMI_DISPOSABLE) && !entity.m_6144_()));
        }
    }
}

