/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.cucumber.client.model.RetextureableBlockModelWrapper;
import com.blakebr0.cucumber.client.model.RetextureableItemModelWrapper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceCrossbowItem;
import com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class ModelHandler {
    private static final ResourceLocation MISSING_NO = new ResourceLocation("minecraft", "missingno");
    private static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("minecraft", "textures/atlas/blocks.png");

    @SubscribeEvent
    public void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        if (!((Boolean)ModConfigs.ANIMATED_GROWTH_ACCELERATORS.get()).booleanValue()) {
            for (String type : new String[]{"block", "item"}) {
                for (String tier : new String[]{"inferium", "prudentium", "tertium", "imperium", "supremium"}) {
                    event.register(new ResourceLocation("mysticalagriculture", String.format("%s/%s_growth_accelerator_static", type, tier)));
                }
            }
        }
        for (int i = 0; i < 8; ++i) {
            event.register(new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
            event.register(new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
        }
        event.register(new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        event.register(new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
    }

    @SubscribeEvent
    public void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map registry = event.getModels();
        ModelBakery bakery = event.getModelBakery();
        if (!((Boolean)ModConfigs.ANIMATED_GROWTH_ACCELERATORS.get()).booleanValue()) {
            for (String tier : new String[]{"inferium", "prudentium", "tertium", "imperium", "supremium"}) {
                String loc = String.format("%s_growth_accelerator", tier);
                BakedModel blockModel = (BakedModel)registry.get(new ResourceLocation("mysticalagriculture", "block/" + loc + "_static"));
                BakedModel itemModel = (BakedModel)registry.get(new ResourceLocation("mysticalagriculture", "item/" + loc + "_static"));
                registry.replace(new ModelResourceLocation("mysticalagriculture:" + loc), blockModel);
                registry.replace(new ModelResourceLocation("mysticalagriculture:" + loc, "inventory"), itemModel);
            }
        }
        HashMap<ResourceLocation, BakedModel[]> cropModels = new HashMap<ResourceLocation, BakedModel[]>();
        HashMap<ResourceLocation, RetextureableBlockModelWrapper> cropModelsGrown = new HashMap<ResourceLocation, RetextureableBlockModelWrapper>();
        for (CropType cropType : CropRegistry.getInstance().getTypes()) {
            cropModels.put(cropType.getId(), (BakedModel[])IntStream.range(0, 7).mapToObj(i -> (BakedModel)registry.get(new ResourceLocation(cropType.getStemModel() + "_" + i))).toArray(BakedModel[]::new));
            UnbakedModel model = bakery.m_119341_(new ResourceLocation(cropType.getStemModel() + "_7"));
            RetextureableBlockModelWrapper modelWrapper = new RetextureableBlockModelWrapper((BlockModel)model);
            cropModelsGrown.put(cropType.getId(), modelWrapper);
        }
        Function<Material, TextureAtlasSprite> getSprite = arg_0 -> ((AtlasSet)bakery.getAtlasSet()).m_117971_(arg_0);
        ItemModelGenerator generator = new ItemModelGenerator();
        UnbakedModel essenceModel = bakery.m_119341_(new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        RetextureableItemModelWrapper essenceModelWrapper = new RetextureableItemModelWrapper((BlockModel)essenceModel);
        UnbakedModel seedsModel = bakery.m_119341_(new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
        RetextureableItemModelWrapper seedsModelWrapper = new RetextureableItemModelWrapper((BlockModel)seedsModel);
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            ModelResourceLocation location;
            BakedModel bakedModel;
            ItemNameBlockItem seeds;
            ResourceLocation seedsId;
            ModelResourceLocation location2;
            BakedModel bakedModel2;
            Item essence;
            ResourceLocation essenceId;
            CropTextures textures = crop.getTextures();
            CropBlock crops = crop.getCropBlock();
            ResourceLocation cropId = ForgeRegistries.BLOCKS.getKey((Object)crops);
            if (cropId != null) {
                for (int i2 = 0; i2 < 7; ++i2) {
                    ModelResourceLocation location3 = new ModelResourceLocation(cropId, "age=" + i2);
                    BakedModel bakedModel3 = (BakedModel)registry.get(location3);
                    if (bakedModel3 != null && !bakedModel3.getParticleIcon(ModelData.EMPTY).m_118413_().equals((Object)MISSING_NO)) continue;
                    ResourceLocation type = crop.getType().getId();
                    registry.replace(location3, ((BakedModel[])cropModels.get(type))[i2]);
                }
                ModelResourceLocation location4 = new ModelResourceLocation(cropId, "age=7");
                BakedModel bakedModel4 = (BakedModel)registry.get(location4);
                if (bakedModel4 == null || bakedModel4.getParticleIcon(ModelData.EMPTY).m_118413_().equals((Object)MISSING_NO)) {
                    ResourceLocation texture = crop.getTextures().getFlowerTexture();
                    RetextureableBlockModelWrapper cropRetexturedModel = ((RetextureableBlockModelWrapper)cropModelsGrown.get(crop.getType().getId())).retexture(ImmutableMap.of((Object)"flower", (Object)texture.toString()));
                    BakedModel cropBakedModel = cropRetexturedModel.m_7611_(bakery, getSprite, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)location4);
                    registry.replace(location4, cropBakedModel);
                }
            }
            if ((essenceId = ForgeRegistries.ITEMS.getKey((Object)(essence = crop.getEssenceItem()))) != null && ((bakedModel2 = (BakedModel)registry.get(location2 = new ModelResourceLocation(essenceId, "inventory"))) == null || bakedModel2.getParticleIcon(ModelData.EMPTY).m_118413_().equals((Object)MISSING_NO))) {
                ResourceLocation texture = textures.getEssenceTexture();
                RetextureableItemModelWrapper retexture = essenceModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
                BlockModel generated = generator.m_111670_(getSprite, (BlockModel)retexture);
                BakedModel model = generated.m_111449_(bakery, generated, getSprite, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)location2, false);
                registry.replace(location2, model);
            }
            if ((seedsId = ForgeRegistries.ITEMS.getKey((Object)(seeds = crop.getSeedsItem()))) == null || (bakedModel = (BakedModel)registry.get(location = new ModelResourceLocation(seedsId, "inventory"))) != null && !bakedModel.getParticleIcon(ModelData.EMPTY).m_118413_().equals((Object)MISSING_NO)) continue;
            ResourceLocation texture = textures.getSeedTexture();
            RetextureableItemModelWrapper retexture = seedsModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
            BlockModel generated = generator.m_111670_(getSprite, (BlockModel)retexture);
            BakedModel model = generated.m_111449_(bakery, generated, getSprite, (ModelState)BlockModelRotation.X0_Y0, (ResourceLocation)location, false);
            registry.replace(location, model);
        }
        stopwatch.stop();
        MysticalAgriculture.LOGGER.info("Model replacement took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)BLOCK_ATLAS)) {
            for (Crop crop : CropRegistry.getInstance().getCrops()) {
                CropTextures textures = crop.getTextures();
                event.addSprite(textures.getFlowerTexture());
                event.addSprite(textures.getEssenceTexture());
                event.addSprite(textures.getSeedTexture());
            }
            event.addSprite(new ResourceLocation("mysticalagriculture", "block/essence_vessel_contents"));
        }
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            ItemBlockRenderTypes.setRenderLayer((Block)crop.getCropBlock(), (RenderType)RenderType.m_110457_());
        }
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.EXPERIENCE_CAPSULE.get()), (ResourceLocation)new ResourceLocation("fill"), (ItemPropertyFunction)ExperienceCapsuleItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SOUL_JAR.get()), (ResourceLocation)new ResourceLocation("fill"), (ItemPropertyFunction)SoulJarItem.getFillPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.INFERIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.PRUDENTIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.TERTIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.IMPERIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.SUPREMIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceBowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceBowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (ItemPropertyFunction)EssenceCrossbowItem.getPullPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (ItemPropertyFunction)EssenceCrossbowItem.getPullingPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (ItemPropertyFunction)EssenceCrossbowItem.getChargedPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (ItemPropertyFunction)EssenceCrossbowItem.getFireworkPropertyGetter());
            ItemProperties.register((Item)((Item)ModItems.AWAKENED_SUPREMIUM_FISHING_ROD.get()), (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)EssenceFishingRodItem.getCastPropertyGetter());
        });
    }
}

