/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.util;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.lib.ModTooltips;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public enum EssenceAppleTier {
    INFERIUM(6, 0.3f, MobEffects.f_19617_),
    PRUDENTIUM(8, 0.4f, MobEffects.f_19617_, MobEffects.f_19596_),
    TERTIUM(10, 0.5f, MobEffects.f_19617_, MobEffects.f_19596_, MobEffects.f_19606_),
    IMPERIUM(12, 0.6f, MobEffects.f_19617_, MobEffects.f_19596_, MobEffects.f_19606_, MobEffects.f_19605_),
    SUPREMIUM(16, 0.7f, MobEffects.f_19617_, MobEffects.f_19596_, MobEffects.f_19606_, MobEffects.f_19605_, MobEffects.f_19600_),
    INSANIUM(20, 0.8f, MobEffects.f_19617_, MobEffects.f_19596_, MobEffects.f_19606_, MobEffects.f_19605_, MobEffects.f_19600_, MobEffects.f_19598_);

    private final Consumer<LivingEntity> onFoodEaten;
    private final List<Component> tooltip;
    private final int hunger;
    private final float saturation;
    private final MobEffect[] effects;

    private EssenceAppleTier(int hunger, float saturation, MobEffect ... effects) {
        this.hunger = hunger;
        this.saturation = saturation;
        this.effects = effects;
        this.onFoodEaten = entity -> Arrays.stream(effects).forEach(e -> EssenceAppleTier.addPotionEffect(entity, e));
        this.tooltip = new ArrayList<Component>();
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void onFoodEaten(LivingEntity entity) {
        this.onFoodEaten.accept(entity);
    }

    public List<Component> getTooltip() {
        if (this.tooltip.isEmpty()) {
            Arrays.stream(this.effects).forEach(e -> {
                MutableComponent buff = Component.m_237113_((String)(e.m_19482_().getString() + " II"));
                Integer buffDuration = (Integer)ModConfigs.ESSENCE_APPLE_DURATION.get();
                int minutes = Math.floorDiv(buffDuration, 60);
                String seconds = String.format("%02d", buffDuration % 60);
                MutableComponent duration = Component.m_237113_((String)(minutes + ":" + seconds));
                this.tooltip.add((Component)ModTooltips.BUFF_LINE.args(new Object[]{buff, duration}).build());
            });
        }
        return this.tooltip;
    }

    private static void addPotionEffect(LivingEntity entity, MobEffect effect) {
        int effectDuration = (Integer)ModConfigs.ESSENCE_APPLE_DURATION.get() * 20;
        MobEffectInstance current = entity.m_21124_(effect);
        int duration = current != null ? current.m_19557_() : 0;
        entity.m_7292_(new MobEffectInstance(effect, duration + effectDuration, 1));
    }
}

