/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.lib;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.init.ModBlocks;
import com.blakebr0.mysticalagradditions.init.ModItems;
import com.blakebr0.mysticalagriculture.api.IMysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.api.MysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.api.lib.PluginConfig;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;

@MysticalAgriculturePlugin
public final class ModCorePlugin
implements IMysticalAgriculturePlugin {
    private static final boolean DEBUG = !FMLEnvironment.production;
    public static final CropTier CROP_TIER_6 = new CropTier(new ResourceLocation("mysticalagradditions", "6"), 6, 4194398, ChatFormatting.DARK_PURPLE);
    public static final Crop NETHER_STAR = new Crop(new ResourceLocation("mysticalagradditions", "nether_star"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"minecraft:nether_star"));
    public static final Crop DRAGON_EGG = new Crop(new ResourceLocation("mysticalagradditions", "dragon_egg"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"mysticalagradditions:dragon_scale"));
    public static final Crop GAIA_SPIRIT = new Crop(new ResourceLocation("mysticalagradditions", "gaia_spirit"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"botania:life_essence"));
    public static final Crop AWAKENED_DRACONIUM = new Crop(new ResourceLocation("mysticalagradditions", "awakened_draconium"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.tag((String)"forge:ingots/draconium_awakened"));
    public static final Crop NEUTRONIUM = new Crop(new ResourceLocation("mysticalagradditions", "neutronium"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"avaritia:neutronium_ingot"));
    public static final Crop NITRO_CRYSTAL = new Crop(new ResourceLocation("mysticalagradditions", "nitro_crystal"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"powah:crystal_nitro"));

    public void configure(PluginConfig config) {
        config.setModId("mysticalagradditions");
        config.disableDynamicSeedCraftingRecipes();
        config.disableDynamicSeedInfusionRecipes();
        config.disableDynamicSeedReprocessingRecipes();
    }

    public void onRegisterCrops(ICropRegistry registry) {
        registry.registerTier(CROP_TIER_6);
        registry.register(NETHER_STAR);
        registry.register(DRAGON_EGG);
        registry.register(ModCorePlugin.withRequiredMods(GAIA_SPIRIT, "botania"));
        registry.register(ModCorePlugin.withRequiredMods(AWAKENED_DRACONIUM, "draconicevolution"));
        registry.register(ModCorePlugin.withRequiredMods(NEUTRONIUM, "avaritia"));
        registry.register(ModCorePlugin.withRequiredMods(NITRO_CRYSTAL, "powah"));
    }

    public void onPostRegisterCrops(ICropRegistry registry) {
        CROP_TIER_6.setFarmland(ModBlocks.INSANIUM_FARMLAND).setEssence(ModItems.INSANIUM_ESSENCE).setFertilizable(((Boolean)ModConfigs.FERTILIZABLE_CROPS.get()).booleanValue()).setSecondarySeedDrop(false);
        NETHER_STAR.setCruxBlock(ModBlocks.NETHER_STAR_CRUX);
        DRAGON_EGG.setCruxBlock(ModBlocks.DRAGON_EGG_CRUX);
        GAIA_SPIRIT.setCruxBlock(ModBlocks.GAIA_SPIRIT_CRUX);
        AWAKENED_DRACONIUM.setCruxBlock(ModBlocks.AWAKENED_DRACONIUM_CRUX);
        NEUTRONIUM.setCruxBlock(ModBlocks.NEUTRONIUM_CRUX);
        NITRO_CRYSTAL.setCruxBlock(ModBlocks.NITRO_CRYSTAL_CRUX);
    }

    private static Crop withRequiredMods(Crop crop, String ... mods) {
        if (DEBUG) {
            return crop;
        }
        boolean enabled = Arrays.stream(mods).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        return crop.setEnabled(enabled);
    }
}

