/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;

public class FormationProtocol<T extends MultiblockData> {
    public static final int MAX_SIZE = 18;
    private final IMultiblock<T> pointer;
    private final Structure structure;
    private final MultiblockManager<T> manager;
    public final Set<BlockPos> locations = new ObjectOpenHashSet();
    public final Set<BlockPos> internalLocations = new ObjectOpenHashSet();
    public final Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    public final Set<UUID> idsFound = new ObjectOpenHashSet();

    public FormationProtocol(IMultiblock<T> tile, Structure structure) {
        this.pointer = tile;
        this.structure = structure;
        this.manager = tile.getManager();
    }

    private StructureResult<T> buildStructure(IStructureValidator<T> validator) {
        T structure = this.pointer.createMultiblock();
        if (!((MultiblockData)structure).setShape(validator.getShape())) {
            return this.fail(FormationResult.FAIL);
        }
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        FormationResult result = validator.validate(this, (Long2ObjectMap<ChunkAccess>)chunkMap);
        if (!result.isFormed()) {
            return this.fail(result);
        }
        ((MultiblockData)structure).locations = this.locations;
        ((MultiblockData)structure).internalLocations = this.internalLocations;
        ((MultiblockData)structure).valves = this.valves;
        result = validator.postcheck(structure, (Long2ObjectMap<ChunkAccess>)chunkMap);
        return result.isFormed() ? this.form(structure, this.idsFound) : this.fail(result);
    }

    public FormationResult doUpdate() {
        IStructureValidator<T> validator = this.manager.createValidator();
        Level world = this.pointer.getTileWorld();
        validator.init(world, this.manager, this.structure);
        if (!validator.precheck()) {
            return FormationResult.FAIL;
        }
        StructureResult<T> result = this.buildStructure(validator);
        Object structureFound = result.structureFound;
        BlockPos pointerPos = this.pointer.getTilePos();
        if (structureFound != null && ((MultiblockData)structureFound).locations.contains(pointerPos)) {
            this.pointer.setMultiblockData(this.manager, (MultiblockData)structureFound);
            ((MultiblockData)structureFound).setFormedForce(true);
            MultiblockCache cache = null;
            UUID idToUse = null;
            if (!result.idsFound.isEmpty()) {
                MultiblockCache.RejectContents rejectContents = new MultiblockCache.RejectContents();
                for (UUID id : result.idsFound) {
                    MultiblockCache<T> foundCache = this.manager.pullInventory(world, id);
                    if (foundCache == null) continue;
                    if (idToUse == null) {
                        cache = foundCache;
                        idToUse = id;
                        continue;
                    }
                    cache.merge(foundCache, rejectContents);
                }
                if (!rejectContents.rejectedItems.isEmpty()) {
                    Vec3 dropPosition = Vec3.m_82512_((Vec3i)pointerPos);
                    Player nearestPlayer = world.m_45924_(dropPosition.f_82479_, dropPosition.f_82480_, dropPosition.f_82481_, 25.0, true);
                    if (nearestPlayer != null) {
                        dropPosition = nearestPlayer.m_20182_();
                    }
                    for (ItemStack rejectedItem : rejectContents.rejectedItems) {
                        world.m_7967_((Entity)new ItemEntity(world, dropPosition.f_82479_, dropPosition.f_82480_, dropPosition.f_82481_, rejectedItem));
                    }
                }
                if (!rejectContents.rejectedGases.isEmpty() && MekanismAPI.getRadiationManager().isRadiationEnabled()) {
                    double radiation = 0.0;
                    for (GasStack rejectedGas : rejectContents.rejectedGases) {
                        radiation += rejectedGas.mapAttributeToDouble(GasAttributes.Radiation.class, (stored, attribute) -> (double)stored.getAmount() * attribute.getRadioactivity());
                    }
                    if (radiation > 0.0) {
                        Coord4D dumpLocation = new Coord4D((Vec3i)((MultiblockData)structureFound).getBounds().getCenter(), world);
                        MekanismAPI.getRadiationManager().radiate(dumpLocation, radiation);
                    }
                }
            }
            if (idToUse == null) {
                idToUse = this.manager.getUniqueInventoryID();
                cache = this.manager.createCache();
            }
            cache.apply(structureFound);
            ((MultiblockData)structureFound).inventoryID = idToUse;
            ((MultiblockData)structureFound).onCreated(world);
            return FormationResult.SUCCESS;
        }
        this.pointer.getStructure().removeMultiblock(world);
        return result.result();
    }

    protected static Component text(BlockPos pos) {
        return MekanismLang.GENERIC_PARENTHESIS.translate(MekanismLang.GENERIC_BLOCK_POS.translate(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
    }

    public static int explore(BlockPos start, Predicate<BlockPos> checker) {
        return FormationProtocol.explore(start, checker, 5832);
    }

    public static int explore(BlockPos start, Predicate<BlockPos> checker, int maxCount) {
        if (!checker.test(start)) {
            return 0;
        }
        LinkedList<BlockPos> openSet = new LinkedList<BlockPos>();
        ObjectOpenHashSet traversed = new ObjectOpenHashSet();
        openSet.add(start);
        traversed.add(start);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            int traversedSize = traversed.size();
            if (traversedSize >= maxCount) {
                return traversedSize;
            }
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = ptr.m_121945_(side);
                if (traversed.contains(offset) || !checker.test(offset)) continue;
                openSet.add(offset);
                traversed.add(offset);
            }
        }
        return traversed.size();
    }

    private StructureResult<T> fail(FormationResult result) {
        return new StructureResult<Object>(result, null, null);
    }

    private StructureResult<T> form(T structureFound, Set<UUID> idsFound) {
        return new StructureResult<T>(FormationResult.SUCCESS, structureFound, idsFound);
    }

    public static class FormationResult {
        public static final FormationResult SUCCESS = new FormationResult(true, null, false);
        public static final FormationResult FAIL = new FormationResult(false, null, false);
        private final Component resultText;
        private final boolean formed;
        private final boolean noIgnore;

        private FormationResult(boolean formed, Component resultText, boolean noIgnore) {
            this.formed = formed;
            this.resultText = resultText;
            this.noIgnore = noIgnore;
        }

        public static FormationResult fail(ILangEntry text, BlockPos pos) {
            return FormationResult.fail(text, pos, false);
        }

        public static FormationResult fail(ILangEntry text, BlockPos pos, boolean noIgnore) {
            return FormationResult.fail((Component)text.translateColored(EnumColor.GRAY, EnumColor.INDIGO, FormationProtocol.text(pos)), noIgnore);
        }

        public static FormationResult fail(ILangEntry text) {
            return FormationResult.fail(text, false);
        }

        public static FormationResult fail(ILangEntry text, boolean noIgnore) {
            return FormationResult.fail((Component)text.translateColored(EnumColor.GRAY, new Object[0]), noIgnore);
        }

        public static FormationResult fail(Component text) {
            return FormationResult.fail(text, false);
        }

        public static FormationResult fail(Component text, boolean noIgnore) {
            return new FormationResult(false, text, noIgnore);
        }

        public boolean isFormed() {
            return this.formed;
        }

        public boolean isNoIgnore() {
            return this.noIgnore;
        }

        public Component getResultText() {
            return this.resultText;
        }
    }

    private record StructureResult<T extends MultiblockData>(FormationResult result, T structureFound, Set<UUID> idsFound) {
    }

    public static enum StructureRequirement {
        IGNORED,
        FRAME,
        OTHER,
        INNER;

        public static final StructureRequirement[] REQUIREMENTS;

        boolean needsFrame() {
            return this == FRAME;
        }

        boolean isCasing() {
            return this != INNER;
        }

        static {
            REQUIREMENTS = StructureRequirement.values();
        }
    }

    public static enum CasingType {
        FRAME,
        VALVE,
        OTHER,
        INVALID;


        boolean isFrame() {
            return this == FRAME;
        }

        boolean isValve() {
            return this == VALVE;
        }
    }
}

