/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ItemArmoredFreeRunners
extends ItemFreeRunners
implements IAttributeRefresher {
    private static final ArmoredFreeRunnerMaterial ARMORED_FREE_RUNNER_MATERIAL = new ArmoredFreeRunnerMaterial();
    private final AttributeCache attributeCache;

    public ItemArmoredFreeRunners(Item.Properties properties) {
        super(ARMORED_FREE_RUNNER_MATERIAL, properties);
        this.attributeCache = new AttributeCache(this, MekanismConfig.gear.armoredFreeRunnerArmor, MekanismConfig.gear.armoredFreeRunnerToughness, MekanismConfig.gear.armoredFreeRunnerKnockbackResistance);
    }

    @Override
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.armoredFreeRunners());
    }

    public int m_40404_() {
        return this.m_40401_().m_7365_(this.m_40402_());
    }

    public float m_40405_() {
        return this.m_40401_().m_6651_();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        return slot == this.m_40402_() ? (Multimap)this.attributeCache.get() : ImmutableMultimap.of();
    }

    @Override
    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = f_40380_[this.m_40402_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.m_40401_().m_6649_(), AttributeModifier.Operation.ADDITION));
    }

    @NothingNullByDefault
    private static class ArmoredFreeRunnerMaterial
    extends ItemFreeRunners.FreeRunnerMaterial {
        private ArmoredFreeRunnerMaterial() {
        }

        @Override
        public int m_7365_(EquipmentSlot slotType) {
            return slotType == EquipmentSlot.FEET ? MekanismConfig.gear.armoredFreeRunnerArmor.getOrDefault() : 0;
        }

        @Override
        public String m_6082_() {
            return "mekanism:free_runners_armored";
        }

        @Override
        public float m_6651_() {
            return MekanismConfig.gear.armoredFreeRunnerToughness.getOrDefault();
        }

        @Override
        public float m_6649_() {
            return MekanismConfig.gear.armoredFreeRunnerKnockbackResistance.getOrDefault();
        }
    }
}

