/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.DecomposedRecipeBuilder;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.RecipeComponentEqualityCheckers;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.recipe.ingredient.IMultiIngredient;
import mekanism.common.recipe.ingredient.creator.ItemStackIngredientCreator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public class CrTRecipeComponents {
    public static final IRecipeComponent<Double> CHANCE = IRecipeComponent.simple((ResourceLocation)Mekanism.rl("chance"), (TypeToken)new TypeToken<Double>(){}, RecipeComponentEqualityCheckers::areNumbersEqual);
    public static final IRecipeComponent<FloatingLong> ENERGY = IRecipeComponent.simple((ResourceLocation)Mekanism.rl("energy"), (TypeToken)new TypeToken<FloatingLong>(){}, FloatingLong::equals);
    public static final PairedRecipeComponent<ItemStackIngredient, IItemStack> ITEM = new PairedRecipeComponent(IRecipeComponent.composite((ResourceLocation)Mekanism.rl("input/item"), (TypeToken)new TypeToken<ItemStackIngredient>(){}, (a, b) -> {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a instanceof ItemStackIngredientCreator.SingleItemStackIngredient) {
            ItemStackIngredientCreator.SingleItemStackIngredient as = (ItemStackIngredientCreator.SingleItemStackIngredient)a;
            if (b instanceof ItemStackIngredientCreator.SingleItemStackIngredient) {
                ItemStackIngredientCreator.SingleItemStackIngredient bs = (ItemStackIngredientCreator.SingleItemStackIngredient)b;
                if (as.getAmountRaw() == bs.getAmountRaw()) {
                    return RecipeComponentEqualityCheckers.areIngredientsEqual((IIngredient)IIngredient.fromIngredient((Ingredient)as.getInputRaw()), (IIngredient)IIngredient.fromIngredient((Ingredient)bs.getInputRaw()));
                }
            }
        }
        return false;
    }, CrTRecipeComponents::unwrapIngredient, ingredients -> (ItemStackIngredient)IngredientCreatorAccess.item().from(ingredients.stream())), BuiltinRecipeComponents.Output.ITEMS);
    public static final PairedRecipeComponent<FluidStackIngredient, IFluidStack> FLUID = new PairedRecipeComponent(IRecipeComponent.composite((ResourceLocation)Mekanism.rl("input/fluid"), (TypeToken)new TypeToken<FluidStackIngredient>(){}, Objects::equals, CrTRecipeComponents::unwrapIngredient, ingredients -> (FluidStackIngredient)IngredientCreatorAccess.fluid().from(ingredients.stream())), IRecipeComponent.simple((ResourceLocation)Mekanism.rl("output/fluid"), (TypeToken)new TypeToken<IFluidStack>(){}, (a, b) -> a.getInternal().isFluidStackIdentical(b.getInternal())));
    public static final ChemicalRecipeComponent<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient, ICrTChemicalStack.ICrTGasStack> GAS = new ChemicalRecipeComponent(ChemicalType.GAS, new TypeToken<ChemicalStackIngredient.GasStackIngredient>(){}, new TypeToken<ICrTChemicalStack.ICrTGasStack>(){});
    public static final ChemicalRecipeComponent<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient, ICrTChemicalStack.ICrTInfusionStack> INFUSION = new ChemicalRecipeComponent(ChemicalType.INFUSION, new TypeToken<ChemicalStackIngredient.InfusionStackIngredient>(){}, new TypeToken<ICrTChemicalStack.ICrTInfusionStack>(){});
    public static final ChemicalRecipeComponent<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient, ICrTChemicalStack.ICrTPigmentStack> PIGMENT = new ChemicalRecipeComponent(ChemicalType.PIGMENT, new TypeToken<ChemicalStackIngredient.PigmentStackIngredient>(){}, new TypeToken<ICrTChemicalStack.ICrTPigmentStack>(){});
    public static final ChemicalRecipeComponent<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient, ICrTChemicalStack.ICrTSlurryStack> SLURRY = new ChemicalRecipeComponent(ChemicalType.SLURRY, new TypeToken<ChemicalStackIngredient.SlurryStackIngredient>(){}, new TypeToken<ICrTChemicalStack.ICrTSlurryStack>(){});
    public static final List<ChemicalRecipeComponent<?, ?, ?, ?>> CHEMICAL_COMPONENTS = List.of(GAS, INFUSION, PIGMENT, SLURRY);

    private CrTRecipeComponents() {
    }

    private static <TYPE, INGREDIENT extends InputIngredient<TYPE>> Collection<INGREDIENT> unwrapIngredient(INGREDIENT ingredient) {
        if (ingredient instanceof IMultiIngredient) {
            return ((IMultiIngredient)ingredient).getIngredients();
        }
        return Collections.singletonList(ingredient);
    }

    public record PairedRecipeComponent<INPUT, OUTPUT>(IRecipeComponent<INPUT> input, IRecipeComponent<OUTPUT> output) {
    }

    public record ChemicalRecipeComponent<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>>(ChemicalType chemicalType, IRecipeComponent<INGREDIENT> input, IRecipeComponent<CRT_STACK> output) {
        ChemicalRecipeComponent(ChemicalType chemicalType, TypeToken<INGREDIENT> inputType, TypeToken<CRT_STACK> outputType) {
            this(chemicalType, inputType, outputType, IngredientCreatorAccess.getCreatorForType(chemicalType));
        }

        private ChemicalRecipeComponent(ChemicalType chemicalType, TypeToken<INGREDIENT> inputType, TypeToken<CRT_STACK> outputType, IChemicalStackIngredientCreator<CHEMICAL, STACK, INGREDIENT> ingredientCreator) {
            this(chemicalType, IRecipeComponent.composite((ResourceLocation)Mekanism.rl("input/" + chemicalType.m_7912_()), inputType, Objects::equals, CrTRecipeComponents::unwrapIngredient, ingredients -> (ChemicalStackIngredient)ingredientCreator.from((Object)ingredients.stream())), IRecipeComponent.simple((ResourceLocation)Mekanism.rl("output/" + chemicalType.m_7912_()), outputType, (a, b) -> a.isTypeEqual(b) && a.getAmount() == b.getAmount()));
        }

        public DecomposedRecipeBuilder withOutput(DecomposedRecipeBuilder builder, List<STACK> output) {
            return builder.with(this.output(), CrTUtils.convertChemical(output));
        }
    }
}

