/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.conditions;

import com.kotori316.limiter.TestSpawn;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;

public abstract class StringLimitSerializer<T extends TestSpawn, Value>
extends TestSpawn.Serializer<T> {
    public abstract Value fromString(String var1);

    public abstract String valueToString(Value var1);

    public abstract String saveKey();

    public abstract T instance(Value var1);

    public abstract Value getter(T var1);

    @Override
    public Set<String> propertyKeys() {
        return Collections.singleton(this.saveKey());
    }

    @Override
    public <T1> T from(Dynamic<T1> dynamic) {
        String valueString = dynamic.get(this.saveKey()).asString("INVALID");
        Value value = this.fromString(valueString);
        if (value == null) {
            throw new IllegalArgumentException("Value is null, by input: " + valueString + ", whole: " + dynamic.getValue());
        }
        return this.instance(value);
    }

    @Override
    public <T1> T1 to(TestSpawn a, DynamicOps<T1> ops) {
        Value value = this.getter(a);
        String valueString = this.valueToString(value);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(ops.createString(this.saveKey()), ops.createString(valueString));
        return (T1)ops.createMap(map);
    }

    public static <Type extends TestSpawn, Value> StringLimitSerializer<Type, Value> fromFunction(Function<Type, Value> getter, Function<Value, Type> instance, Function<Value, String> asString, Function<String, Value> fromString, String saveKey, String typeName) {
        return StringLimitSerializer.fromFunction(getter, instance, asString, fromString, saveKey, typeName, () -> null);
    }

    public static <Type extends TestSpawn, Value> StringLimitSerializer<Type, Value> fromFunction(Function<Type, Value> getter, Function<Value, Type> instance, Function<Value, String> asString, Function<String, Value> fromString, String saveKey, String typeName, @Nullable Value[] values) {
        return StringLimitSerializer.fromFunction(getter, instance, asString, fromString, saveKey, typeName, () -> values);
    }

    public static <Type extends TestSpawn, Value> StringLimitSerializer<Type, Value> fromFunction(final Function<Type, Value> getter, final Function<Value, Type> instance, final Function<Value, String> asString, final Function<String, Value> fromString, final String saveKey, final String typeName, final @Nonnull Supplier<Value[]> valueSupplier) {
        return new StringLimitSerializer<Type, Value>(){

            @Override
            public Value fromString(String s) {
                return fromString.apply(s);
            }

            @Override
            public String valueToString(Value value) {
                return (String)asString.apply(value);
            }

            @Override
            public String saveKey() {
                return saveKey;
            }

            @Override
            public Type instance(Value value) {
                return (TestSpawn)instance.apply(value);
            }

            @Override
            public Value getter(Type type) {
                return getter.apply(type);
            }

            @Override
            public String getType() {
                return typeName;
            }

            @Override
            public Set<String> possibleValues(String property, boolean suggesting, SharedSuggestionProvider provider) {
                Object[] values = (Object[])valueSupplier.get();
                if (values != null && property.equals(this.saveKey())) {
                    if (!suggesting && Enum.class.isAssignableFrom(values.getClass().getComponentType())) {
                        return Arrays.stream(values).flatMap(v -> Stream.of(this.valueToString(v), ((Enum)v).name())).collect(Collectors.toSet());
                    }
                    return Arrays.stream(values).map(this::valueToString).collect(Collectors.toSet());
                }
                return Collections.emptySet();
            }
        };
    }
}

