/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.conditions;

import com.kotori316.limiter.TestSpawn;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;

public class RandomLimit
implements TestSpawn {
    public static final TestSpawn.Serializer<RandomLimit> SERIALIZER = new Serializer();
    private final double p;
    private final Random random;

    public RandomLimit(double p) {
        this.p = p;
        this.random = new Random();
        if (p < 0.0 || 1.0 < p) {
            throw new IllegalArgumentException("p doesn't satisfy 0 <= p <= 1, p=" + p);
        }
    }

    @Override
    public boolean test(BlockGetter worldIn, BlockPos pos, EntityType<?> entityTypeIn, @Nullable MobSpawnType reason) {
        return this.random.nextDouble() < this.p;
    }

    @Override
    public TestSpawn.Serializer<? extends TestSpawn> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public String contentShort() {
        return "random " + this.p;
    }

    public String toString() {
        return "Random{p=" + this.p + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomLimit that = (RandomLimit)o;
        return Double.compare(that.p, this.p) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.p);
    }

    @Override
    public RandomLimit not() {
        return new RandomLimit(1.0 - this.p);
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    private static class Serializer
    extends TestSpawn.Serializer<RandomLimit> {
        private Serializer() {
        }

        @Override
        public String getType() {
            return "random";
        }

        @Override
        public <T> RandomLimit from(Dynamic<T> dynamic) {
            double p = dynamic.get("p").asNumber().map(Number::doubleValue).result().orElseGet(() -> Double.parseDouble(dynamic.get("p").asString("1")));
            return new RandomLimit(p);
        }

        @Override
        public <T> T to(TestSpawn a, DynamicOps<T> ops) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(ops.createString("p"), ops.createDouble(((RandomLimit)a).p));
            return (T)ops.createMap(map);
        }

        @Override
        public Set<String> propertyKeys() {
            return Collections.singleton("p");
        }

        @Override
        public Set<String> possibleValues(String property, boolean suggesting, @Nullable SharedSuggestionProvider provider) {
            return Collections.emptySet();
        }
    }
}

