/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.conditions;

import com.kotori316.limiter.LimitMobSpawn;
import com.kotori316.limiter.TestSpawn;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityLimit
implements TestSpawn {
    public static final TestSpawn.Serializer<EntityLimit> SERIALIZER = new Serializer();
    private final EntityType<?> type;
    private final ResourceLocation key;

    public EntityLimit(EntityType<?> type) {
        this.type = type;
        this.key = null;
        LimitMobSpawn.LOGGER.debug(TestSpawn.MARKER, this.getClass().getSimpleName() + " Instance created with {}", type);
    }

    public EntityLimit(String key) {
        this.type = EntityType.m_20632_((String)key).orElse(null);
        this.key = new ResourceLocation(key);
        LimitMobSpawn.LOGGER.debug(TestSpawn.MARKER, this.getClass().getSimpleName() + " Instance created with {}", (Object)key);
    }

    @Override
    public boolean test(BlockGetter worldIn, BlockPos pos, EntityType<?> entityTypeIn, MobSpawnType reason) {
        return this.type.equals(entityTypeIn);
    }

    public String toString() {
        return "EntityLimit{type=" + this.type + "(" + EntityType.m_20613_(this.type) + ")}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityLimit that = (EntityLimit)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    public TestSpawn.Serializer<? extends TestSpawn> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public String contentShort() {
        if (this.type == null) {
            return String.valueOf(this.key);
        }
        return String.valueOf(EntityType.m_20613_(this.type));
    }

    private static class Serializer
    extends TestSpawn.Serializer<EntityLimit> {
        private Serializer() {
        }

        @Override
        public String getType() {
            return "entity";
        }

        @Override
        public <T> EntityLimit from(Dynamic<T> dynamic) {
            EntityType type = (EntityType)EntityType.m_20632_((String)dynamic.get("entity").asString("INVALID")).orElseThrow(() -> new IllegalArgumentException("Invalid entity name: " + dynamic.getValue()));
            return new EntityLimit(type);
        }

        @Override
        public <T> T to(TestSpawn t, DynamicOps<T> ops) {
            EntityLimit l = (EntityLimit)t;
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            String value = l.type != null ? EntityType.m_20613_(l.type).toString() : Objects.requireNonNull(l.key).toString();
            map.put(ops.createString("entity"), ops.createString(value));
            return (T)ops.createMap(map);
        }

        @Override
        public Set<String> propertyKeys() {
            return Collections.singleton("entity");
        }

        @Override
        public Set<String> possibleValues(String property, boolean suggesting, SharedSuggestionProvider provider) {
            return this.suggestions(property, provider).stream().map(ResourceLocation::toString).collect(Collectors.toSet());
        }

        @Override
        public Set<ResourceLocation> suggestions(String property, @Nullable SharedSuggestionProvider provider) {
            if (property.equals("entity")) {
                return ForgeRegistries.ENTITY_TYPES.getKeys();
            }
            return Collections.emptySet();
        }
    }
}

