/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.annotation.meta.Experimental;
import org.moddingx.libx.datagen.provider.patchouli.BookProperties;
import org.moddingx.libx.datagen.provider.patchouli.CategoryBuilder;
import org.moddingx.libx.datagen.provider.patchouli.EntryBuilder;
import org.moddingx.libx.impl.datagen.FontLoader;
import org.moddingx.libx.impl.datagen.patchouli.translate.TranslationManager;
import org.moddingx.libx.mod.ModX;

@Experimental
public abstract class PatchouliProviderBase
implements DataProvider {
    protected final ModX mod;
    protected final DataGenerator generator;
    protected final ExistingFileHelper fileHelper;
    private final BookProperties properties;
    private final List<CategoryBuilder> categories;
    private final Set<ResourceLocation> categoryIds;
    private final List<EntryBuilder> entries;

    public PatchouliProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper, BookProperties properties) {
        this.mod = mod;
        this.generator = generator;
        this.fileHelper = fileHelper;
        this.properties = properties;
        FontLoader.getFontWidthProvider(fileHelper);
        this.categories = new ArrayList<CategoryBuilder>();
        this.categoryIds = new HashSet<ResourceLocation>();
        this.entries = new ArrayList<EntryBuilder>();
    }

    protected abstract void setup();

    public CategoryBuilder category(String id) {
        CategoryBuilder builder = new CategoryBuilder(this.mod.resource(id));
        this.categories.add(builder);
        this.categoryIds.add(builder.id);
        return builder;
    }

    public EntryBuilder entry(String id) {
        if (this.categories.isEmpty()) {
            throw new IllegalStateException("No categories defined");
        }
        return this.entry(id, this.categories.get((int)(this.categories.size() - 1)).id);
    }

    public EntryBuilder entry(String id, String category) {
        return this.entry(id, this.mod.resource(category));
    }

    public EntryBuilder entry(String id, ResourceLocation category) {
        if (this.mod.modid.equals(category.m_135827_()) && !this.categoryIds.contains(category)) {
            throw new IllegalArgumentException("Unknown category: " + category);
        }
        EntryBuilder builder = new EntryBuilder(id, category);
        this.entries.add(builder);
        return builder;
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " " + this.properties.bookName() + " patchouli book";
    }

    public void m_213708_(@Nonnull CachedOutput cache) throws IOException {
        Path path2;
        BiFunction<String, List<String>, String> translations;
        TranslationManager mgr;
        this.setup();
        if (this.properties.translate()) {
            mgr = new TranslationManager(this.properties.bookName());
            translations = mgr::add;
        } else {
            mgr = null;
            translations = (str, path) -> str;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            CategoryBuilder category = this.categories.get(i);
            path2 = this.generator.m_123916_().resolve(this.properties.packTarget().m_10305_() + "/" + category.id.m_135827_() + "/patchouli_books/" + this.properties.bookName() + "/en_us/categories/" + category.id.m_135815_() + ".json");
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)category.build(translations, i), (Path)path2);
        }
        for (EntryBuilder entry : this.entries) {
            path2 = this.generator.m_123916_().resolve(this.properties.packTarget().m_10305_() + "/" + entry.category.m_135827_() + "/patchouli_books/" + this.properties.bookName() + "/en_us/entries/" + entry.category.m_135815_() + "/" + entry.id + ".json");
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)entry.build(translations, this.fileHelper), (Path)path2);
        }
        if (mgr != null) {
            Path langPath = this.generator.m_123916_().resolve(PackType.CLIENT_RESOURCES.m_10305_() + "/" + this.mod.modid + "_" + this.properties.bookName() + "/lang/en_us.json");
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)mgr.build(), (Path)langPath);
        }
    }
}

