/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.part.PartStateOffsetHandler;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private boolean forceBlockUpdateRender = false;
    private int updateInterval = this.getDefaultUpdateInterval();
    private int priority = 0;
    private int channel = 0;
    private int maxOffset;
    private Vec3i targetOffset = new Vec3i(0, 0, 0);
    private Direction targetSide = null;
    private int id = -1;
    private Map<IAspect, IAspectProperties> aspectProperties = new IdentityHashMap<IAspect, IAspectProperties>();
    private boolean enabled = true;
    private final Map<String, NonNullList<ItemStack>> inventoriesNamed = Maps.newHashMap();
    private final PartStateOffsetHandler<P> offsetHandler = new PartStateOffsetHandler();
    private CapabilityDispatcher capabilities = null;
    private IdentityHashMap<Capability<?>, LazyOptional<Object>> volatileCapabilities = new IdentityHashMap();

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("updateInterval", this.updateInterval);
        tag.m_128405_("priority", this.priority);
        tag.m_128405_("channel", this.channel);
        if (this.targetSide != null) {
            tag.m_128405_("targetSide", this.targetSide.ordinal());
        }
        tag.m_128405_("id", this.id);
        this.writeAspectProperties("aspectProperties", tag);
        tag.m_128379_("enabled", this.enabled);
        if (this.capabilities != null) {
            tag.m_128365_("ForgeCaps", (Tag)this.capabilities.serializeNBT());
        }
        tag.m_128405_("maxOffset", this.maxOffset);
        tag.m_128405_("offsetX", this.targetOffset.m_123341_());
        tag.m_128405_("offsetY", this.targetOffset.m_123342_());
        tag.m_128405_("offsetZ", this.targetOffset.m_123343_());
        ListTag namedInventoriesList = new ListTag();
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.inventoriesNamed.entrySet()) {
            CompoundTag listEntry = new CompoundTag();
            listEntry.m_128359_("tabName", entry.getKey());
            listEntry.m_128405_("itemCount", entry.getValue().size());
            ContainerHelper.m_18973_((CompoundTag)listEntry, entry.getValue());
            namedInventoriesList.add((Object)listEntry);
        }
        tag.m_128365_("inventoriesNamed", (Tag)namedInventoriesList);
        CompoundTag errorsTag = new CompoundTag();
        for (Int2ObjectMap.Entry entry : this.offsetHandler.offsetVariablesSlotMessages.int2ObjectEntrySet()) {
            NBTClassType.writeNbt(MutableComponent.class, (String)String.valueOf(entry.getIntKey()), (Object)((MutableComponent)entry.getValue()), (CompoundTag)errorsTag);
        }
        tag.m_128365_("offsetVariablesSlotMessages", (Tag)errorsTag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.updateInterval = tag.m_128451_("updateInterval");
        this.priority = tag.m_128451_("priority");
        this.channel = tag.m_128451_("channel");
        if (tag.m_128425_("targetSide", 3)) {
            this.targetSide = Direction.values()[tag.m_128451_("targetSide")];
        }
        this.id = tag.m_128451_("id");
        this.aspectProperties.clear();
        this.readAspectProperties("aspectProperties", tag);
        this.enabled = tag.m_128471_("enabled");
        if (this.capabilities != null && tag.m_128441_("ForgeCaps")) {
            this.capabilities.deserializeNBT(tag.m_128469_("ForgeCaps"));
        }
        this.maxOffset = tag.m_128451_("maxOffset");
        this.targetOffset = new Vec3i(tag.m_128451_("offsetX"), tag.m_128451_("offsetY"), tag.m_128451_("offsetZ"));
        for (Tag listEntry : tag.m_128437_("inventoriesNamed", 10)) {
            NonNullList list = NonNullList.m_122780_((int)((CompoundTag)listEntry).m_128451_("itemCount"), (Object)ItemStack.f_41583_);
            String tabName = ((CompoundTag)listEntry).m_128461_("tabName");
            ContainerHelper.m_18980_((CompoundTag)((CompoundTag)listEntry), (NonNullList)list);
            this.inventoriesNamed.put(tabName, (NonNullList<ItemStack>)list);
        }
        this.offsetHandler.offsetVariablesSlotMessages.clear();
        CompoundTag errorsTag = tag.m_128469_("offsetVariablesSlotMessages");
        for (String slot : errorsTag.m_128431_()) {
            MutableComponent unlocalizedString = (MutableComponent)NBTClassType.readNbt(MutableComponent.class, (String)slot, (CompoundTag)errorsTag);
            this.offsetHandler.offsetVariablesSlotMessages.put(Integer.parseInt(slot), (Object)unlocalizedString);
        }
    }

    protected void writeAspectProperties(String name, CompoundTag tag) {
        CompoundTag mapTag = new CompoundTag();
        ListTag list = new ListTag();
        for (Map.Entry<IAspect, IAspectProperties> entry : this.aspectProperties.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_("key", entry.getKey().getUniqueName().toString());
            if (entry.getValue() != null) {
                entryTag.m_128365_("value", (Tag)entry.getValue().toNBT());
            }
            list.add((Object)entryTag);
        }
        mapTag.m_128365_("map", (Tag)list);
        tag.m_128365_(name, (Tag)mapTag);
    }

    public void readAspectProperties(String name, CompoundTag tag) {
        CompoundTag mapTag = tag.m_128469_(name);
        ListTag list = mapTag.m_128437_("map", 10);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entryTag = list.m_128728_(i);
                IAspect key = Aspects.REGISTRY.getAspect(new ResourceLocation(entryTag.m_128461_("key")));
                AspectProperties value = null;
                if (entryTag.m_128441_("value")) {
                    value = new AspectProperties();
                    value.fromNBT(entryTag.m_128469_("value"));
                }
                if (key == null || value == null) continue;
                this.aspectProperties.put(key, value);
            }
        }
    }

    @Override
    public void generateId() {
        this.id = IntegratedDynamics.globalCounters.getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public Vec3i getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public void setTargetOffset(Vec3i targetOffset) {
        this.targetOffset = targetOffset;
        this.markDirty();
    }

    @Override
    public void setTargetSideOverride(Direction targetSide) {
        this.targetSide = targetSide;
    }

    @Override
    @Nullable
    public Direction getTargetSideOverride() {
        return this.targetSide;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    @Override
    public void forceBlockRenderUpdate() {
        this.forceBlockUpdateRender = true;
    }

    @Override
    public boolean isForceBlockRenderUpdateAndReset() {
        boolean wasForceBlockUpdateRender = this.forceBlockUpdateRender;
        this.forceBlockUpdateRender = false;
        return wasForceBlockUpdateRender;
    }

    public void onDirty() {
        this.dirty = true;
        this.forceBlockRenderUpdate();
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect);
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect, properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.enabled != wasEnabled) {
            this.sendUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public NonNullList<ItemStack> getInventoryNamed(String name) {
        return this.inventoriesNamed.get(name);
    }

    @Override
    public void setInventoryNamed(String name, NonNullList<ItemStack> inventory) {
        this.inventoriesNamed.put(name, inventory);
        this.onDirty();
    }

    @Override
    public Map<String, NonNullList<ItemStack>> getInventoriesNamed() {
        return this.inventoriesNamed;
    }

    @Override
    public void clearInventoriesNamed() {
        this.inventoriesNamed.clear();
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), event.getListeners()) : null;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        LazyOptional<Object> o = this.volatileCapabilities.get(capability);
        if (o != null && o.isPresent()) {
            return o.cast();
        }
        return this.capabilities == null ? LazyOptional.empty() : this.capabilities.getCapability(capability);
    }

    @Override
    public <T> void addVolatileCapability(Capability<T> capability, LazyOptional<T> value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(Capability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    protected int getDefaultUpdateInterval() {
        return GeneralConfig.defaultPartUpdateFreq;
    }

    @Override
    public void updateOffsetVariables(P partType, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        this.offsetHandler.updateOffsetVariables(partType, this, network, partNetwork, target);
    }

    @Override
    @Nullable
    public MutableComponent getOffsetVariableError(int slot) {
        return this.offsetHandler.getOffsetVariableError(slot);
    }

    @Override
    public void markOffsetVariablesChanged() {
        this.offsetHandler.markOffsetVariablesChanged();
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        this.markDirty();
    }
}

