/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;

public class CombinedOperator
extends OperatorBase {
    private final String unlocalizedType;

    public CombinedOperator(String symbol, String operatorName, OperatorsFunction function, IValueType outputType) {
        this(symbol, operatorName, function, new IValueType[]{ValueTypes.CATEGORY_ANY}, outputType, null);
    }

    public CombinedOperator(String symbol, String operatorName, OperatorsFunction function, IValueType[] inputTypes, IValueType outputType, @Nullable IConfigRenderPattern configRenderPattern) {
        super(symbol, operatorName, inputTypes, outputType, function, configRenderPattern);
        this.unlocalizedType = "virtual";
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public static abstract class OperatorsFunction
    implements OperatorBase.IFunction {
        private final IOperator[] operators;

        public OperatorsFunction(IOperator ... operators) {
            this.operators = operators;
        }

        public IOperator[] getOperators() {
            return this.operators;
        }

        public int getInputOperatorCount() {
            return this.getOperators().length;
        }
    }

    public static abstract class ListOperatorSerializer<F extends OperatorBase.IFunction>
    implements IOperatorSerializer<CombinedOperator> {
        private final String functionName;
        private final Class<F> functionClass;

        public ListOperatorSerializer(String functionName, Class<F> functionClass) {
            this.functionName = functionName;
            this.functionClass = functionClass;
        }

        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof CombinedOperator && this.functionClass.isInstance(((CombinedOperator)operator).getFunction());
        }

        @Override
        public ResourceLocation getUniqueName() {
            return new ResourceLocation("integrateddynamics", "combined." + this.functionName);
        }

        @Override
        public Tag serialize(CombinedOperator operator) {
            OperatorsFunction function = (OperatorsFunction)operator.getFunction();
            IOperator[] operators = function.getOperators();
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (IOperator functionOperator : operators) {
                CompoundTag elementTag = new CompoundTag();
                elementTag.m_128365_("v", Operators.REGISTRY.serialize(functionOperator));
                list.add((Object)elementTag);
            }
            tag.m_128365_("operators", (Tag)list);
            return tag;
        }

        @Override
        public CombinedOperator deserialize(Tag valueOperator) throws EvaluationException {
            ListTag list;
            try {
                CompoundTag tag = (CompoundTag)valueOperator;
                list = (ListTag)tag.m_128423_("operators");
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                throw new EvaluationException(Component.m_237110_((String)"valuetype.integrateddynamics.error.deserialize", (Object[])new Object[]{valueOperator, e.getMessage()}));
            }
            IOperator[] operators = new IOperator[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                operators[i] = Objects.requireNonNull(Operators.REGISTRY.deserialize(list.m_128728_(i).m_128423_("v")));
            }
            return this.newFunction(operators);
        }

        public abstract CombinedOperator newFunction(IOperator ... var1) throws EvaluationException;
    }

    public static class Flip
    extends OperatorsFunction {
        public Flip(IOperator operator) {
            super(operator);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            int size = variables.getVariables().length;
            IValue[] values = new IValue[size];
            for (int i = 0; i < size; ++i) {
                int targetI = i < 2 ? 1 - i : i;
                values[i] = variables.getValue(targetI);
            }
            return ValueHelpers.evaluateOperator(this.getOperators()[0], values);
        }

        public static CombinedOperator asOperator(IOperator operator) throws EvaluationException {
            CombinedOperator combinedOperator;
            Flip flip = new Flip(operator);
            IValueType[] originalInputTypes = operator.getInputTypes();
            IValueType[] flippedInputTypes = new IValueType[originalInputTypes.length];
            if (originalInputTypes.length < 2) {
                throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.wrong_input_length_virtual", (Object[])new Object[]{Component.m_237115_((String)Operators.OPERATOR_FLIP.getTranslationKey()), Component.m_237115_((String)operator.getTranslationKey()), originalInputTypes.length, 2}));
            }
            for (int i = 0; i < flippedInputTypes.length; ++i) {
                int targetI = i < 2 ? 1 - i : i;
                flippedInputTypes[i] = originalInputTypes[targetI];
            }
            try {
                combinedOperator = new CombinedOperator(":flip:", "flipped", flip, flippedInputTypes, operator.getOutputType(), null);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(Component.m_237115_((String)e.getMessage()));
            }
            return combinedOperator;
        }

        public static class Serializer
        extends ListOperatorSerializer<Flip> {
            public Serializer() {
                super("flip", Flip.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) throws EvaluationException {
                return Flip.asOperator(operators[0]);
            }
        }
    }

    public static class Pipe2
    extends OperatorsFunction {
        public Pipe2(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return Pipe.pipeVariablesToOperators(variables.getVariables(), this.getOperators());
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            return Pipe.asOperator(new Pipe2(operators), ":.2:", "piped2", operators);
        }

        public static class Serializer
        extends ListOperatorSerializer<Pipe2> {
            public Serializer() {
                super("pipe2", Pipe2.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Pipe2.asOperator(operators);
            }
        }
    }

    public static class Pipe
    extends OperatorsFunction {
        public Pipe(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            return Pipe.pipeVariablesToOperators(variables.getVariables(), this.getOperators());
        }

        public static IValue pipeVariablesToOperators(IVariable[] allVariables, IOperator[] operators) throws EvaluationException {
            int firstInputRange = operators.length - 1;
            IVariable input = allVariables[0];
            Object[] intermediates = new IVariable[firstInputRange];
            for (int i = 0; i < firstInputRange; ++i) {
                intermediates[i] = new Variable<IValue>(ValueHelpers.evaluateOperator(operators[i], input));
            }
            Object[] remaining = (IVariable[])ArrayUtils.subarray((Object[])allVariables, (int)1, (int)allVariables.length);
            IVariable[] newVariables = (IVariable[])ArrayUtils.addAll((Object[])intermediates, (Object[])remaining);
            return ValueHelpers.evaluateOperator(operators[operators.length - 1], newVariables);
        }

        public static Pair<IValueType[], IValueType> getPipedInputOutputTypes(IOperator[] operators) {
            int firstInputRange = operators.length - 1;
            Object[] inputTypes = new IValueType[1];
            for (int i = 0; i < operators.length; ++i) {
                Object[] operatorInputTypes = operators[i].getInputTypes();
                if (i < firstInputRange) {
                    if (inputTypes[0] == null) {
                        inputTypes[0] = operatorInputTypes[0];
                        continue;
                    }
                    if (inputTypes[0] == operatorInputTypes[0] || !ValueHelpers.correspondsTo((IValueType)inputTypes[0], (IValueType)operatorInputTypes[0]) || !inputTypes[0].isCategory()) continue;
                    inputTypes[0] = operatorInputTypes[0];
                    continue;
                }
                inputTypes = (IValueType[])ArrayUtils.addAll((Object[])inputTypes, (Object[])((IValueType[])ArrayUtils.subarray((Object[])operatorInputTypes, (int)firstInputRange, (int)operatorInputTypes.length)));
            }
            return Pair.of((Object)inputTypes, (Object)operators[operators.length - 1].getOutputType());
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            return Pipe.asOperator(new Pipe(operators), ":.:", "piped", operators);
        }

        public static CombinedOperator asOperator(OperatorsFunction function, String symbol, String operatorName, final IOperator ... operators) {
            final Pair<IValueType[], IValueType> ioTypes = Pipe.getPipedInputOutputTypes(operators);
            return new CombinedOperator(symbol, operatorName, function, (IValueType)ioTypes.getRight()){

                @Override
                public IValueType getConditionalOutputType(IVariable[] allVariables) {
                    try {
                        return Pipe.pipeVariablesToOperators(allVariables, operators).getType();
                    }
                    catch (EvaluationException e) {
                        return ValueTypes.CATEGORY_ANY;
                    }
                }

                @Override
                public IValueType[] getInputTypes() {
                    return (IValueType[])ioTypes.getLeft();
                }
            };
        }

        public static class Serializer
        extends ListOperatorSerializer<Pipe> {
            public Serializer() {
                super("pipe", Pipe.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Pipe.asOperator(operators);
            }
        }
    }

    public static class Negation
    extends OperatorsFunction {
        public Negation(IOperator operator) {
            super(operator);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValue value = variables.getValue(0);
            IOperator operator = this.getOperators()[0];
            IValue result = ValueHelpers.evaluateOperator(operator, value);
            ValueHelpers.validatePredicateOutput(operator, result);
            return ValueTypeBoolean.ValueBoolean.of(!((ValueTypeBoolean.ValueBoolean)result).getRawValue());
        }

        public static CombinedOperator asOperator(IOperator operator) {
            Negation negation = new Negation(operator);
            return new CombinedOperator("!:", "p_negation", negation, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Negation> {
            public Serializer() {
                super("negation", Negation.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Negation.asOperator(operators[0]);
            }
        }
    }

    public static class Disjunction
    extends OperatorsFunction {
        public Disjunction(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValue value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                IValue result = ValueHelpers.evaluateOperator(operator, value);
                ValueHelpers.validatePredicateOutput(operator, result);
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Disjunction disjunction = new Disjunction(operators);
            return new CombinedOperator(":||:", "p_disjunction", disjunction, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Disjunction> {
            public Serializer() {
                super("disjunction", Disjunction.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Disjunction.asOperator(operators);
            }
        }
    }

    public static class Conjunction
    extends OperatorsFunction {
        public Conjunction(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            IValue value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                IValue result = ValueHelpers.evaluateOperator(operator, value);
                ValueHelpers.validatePredicateOutput(operator, result);
                if (((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return ValueTypeBoolean.ValueBoolean.of(true);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Conjunction conjunction = new Conjunction(operators);
            return new CombinedOperator(":&&:", "p_conjunction", conjunction, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("conjunction", Conjunction.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Conjunction.asOperator(operators);
            }
        }
    }
}

