/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.metal.MetalPressBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class MetalPressRenderer
extends IEBlockEntityRenderer<MetalPressBlockEntity> {
    public static final String NAME = "metal_press_piston";
    public static DynamicModel PISTON;

    public void render(MetalPressBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        MultiblockProcess process;
        int i;
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockPos blockPos = te.m_58899_();
        BlockState state = te.m_58904_().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.METAL_PRESS.get()) {
            return;
        }
        BakedModel model = PISTON.get();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        float piston = 0.0f;
        float[] shift = new float[te.processQueue.size()];
        for (i = 0; i < shift.length; ++i) {
            process = (MultiblockProcess)te.processQueue.get(i);
            if (process == null) continue;
            float processMaxTicks = process.getMaxTicks(te.m_58904_());
            float transportTime = MetalPressBlockEntity.getTransportTime(processMaxTicks);
            float pressTime = MetalPressBlockEntity.getPressTime(processMaxTicks);
            float fProcess = process.processTick;
            shift[i] = fProcess < transportTime ? 0.5f * fProcess / transportTime : (fProcess < processMaxTicks - transportTime ? 0.5f : 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime);
            if (te.mold.m_41619_() || !(fProcess >= transportTime) || !(fProcess < processMaxTicks - transportTime)) continue;
            piston = fProcess < transportTime + pressTime ? (fProcess - transportTime) / pressTime : (fProcess < processMaxTicks - transportTime - pressTime ? 1.0f : 1.0f - (fProcess - (processMaxTicks - transportTime - pressTime)) / pressTime);
        }
        matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), te.getFacing() == Direction.SOUTH ? 180.0f : (te.getFacing() == Direction.WEST ? 90.0f : (te.getFacing() == Direction.EAST ? -90.0f : 0.0f)), true));
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)(-piston * 0.6875f), 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        blockRenderer.m_110937_().renderModel(matrixStack.m_85850_(), bufferIn.m_6299_(RenderType.m_110451_()), state, model, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110451_());
        matrixStack.m_85849_();
        if (!te.mold.m_41619_()) {
            matrixStack.m_85837_(0.0, 0.34, 0.0);
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            float scale = 0.75f;
            matrixStack.m_85841_(scale, scale, 1.0f);
            ClientUtils.mc().m_91291_().m_174269_(te.mold, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
        }
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, -0.35, 1.25);
        for (i = 0; i < shift.length; ++i) {
            MultiblockProcessInWorld inWorld;
            List<ItemStack> displays;
            process = (MultiblockProcess)te.processQueue.get(i);
            if (!(process instanceof MultiblockProcessInWorld) || (displays = (inWorld = (MultiblockProcessInWorld)process).getDisplayItem(te.m_58904_())).isEmpty()) continue;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, (double)(-2.5f * shift[i]));
            if ((double)piston > 0.92) {
                matrixStack.m_85837_(0.0, 0.92 - (double)piston, 0.0);
            }
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            float scale = 0.625f;
            matrixStack.m_85841_(scale, scale, 1.0f);
            ClientUtils.mc().m_91291_().m_174269_(displays.get(0), ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }
}

