/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.common.entities.illager.Bulwark;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ItemStack;

public class ChemthrowerCallbacks
implements ItemCallback<Key> {
    public static final ChemthrowerCallbacks INSTANCE = new ChemthrowerCallbacks();

    @Override
    public Key extractKey(ItemStack stack, LivingEntity owner) {
        CompoundTag upgrades = ChemthrowerItem.getUpgradesStatic(stack);
        return new Key(upgrades.m_128451_("capacity") > 0, upgrades.m_128471_("multitank"));
    }

    @Override
    public boolean shouldRenderGroup(Key stack, String group, RenderType layer) {
        if ("base".equals(group) || "grip".equals(group) || "cage".equals(group) || "tanks".equals(group)) {
            return true;
        }
        if ("large_tank".equals(group) && stack.upgradedCapacity()) {
            return true;
        }
        if ("multi_tank".equals(group) && stack.multitank()) {
            return true;
        }
        return "tank".equals(group);
    }

    @Override
    public void handlePerspective(Key key, LivingEntity holder, ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        if (holder instanceof Bulwark) {
            Bulwark bulwark = (Bulwark)holder;
            if (cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                if (bulwark.m_6768_() == AbstractIllager.IllagerArmPose.CELEBRATING) {
                    mat.m_85837_(-2.0, -1.25, 0.0);
                    mat.m_85845_(Vector3f.f_122225_.m_122240_(-95.0f));
                    mat.m_85845_(Vector3f.f_122227_.m_122240_(-30.0f));
                    mat.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
                } else {
                    mat.m_85845_(new Quaternion(2.0f, -10.0f, -10.0f, true));
                    mat.m_85837_(-0.875, -0.75, 0.3);
                }
            }
        }
    }

    public record Key(boolean upgradedCapacity, boolean multitank) {
    }
}

