/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import shadows.hostilenetworks.client.DataModelItemStackRenderer;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.util.Color;

public class DataModelItem
extends Item {
    public static final String DATA_MODEL = "data_model";
    public static final String ID = "id";
    public static final String DATA = "data";
    public static final String ITERATIONS = "iterations";

    public DataModelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            CachedModel cModel = new CachedModel(pStack, 0);
            if (cModel.getModel() == null) {
                list.add((Component)Component.m_237110_((String)"Error: %s", (Object[])new Object[]{Component.m_237113_((String)"Broke_AF").m_130944_(new ChatFormatting[]{ChatFormatting.OBFUSCATED, ChatFormatting.GRAY})}));
                return;
            }
            int data = DataModelItem.getData(pStack);
            ModelTier tier = ModelTier.getByData(cModel.getModel(), data);
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.tier", (Object[])new Object[]{tier.getComponent()}));
            int dProg = data - cModel.getTierData();
            int dMax = cModel.getNextTierData() - cModel.getTierData();
            if (tier != ModelTier.SELF_AWARE) {
                list.add((Component)Component.m_237110_((String)"hostilenetworks.info.data", (Object[])new Object[]{Component.m_237110_((String)"hostilenetworks.info.dprog", (Object[])new Object[]{dProg, dMax}).m_130940_(ChatFormatting.GRAY)}));
                list.add((Component)Component.m_237110_((String)"hostilenetworks.info.dpk", (Object[])new Object[]{Component.m_237113_((String)("" + cModel.getDataPerKill())).m_130940_(ChatFormatting.GRAY)}));
            }
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.sim_cost", (Object[])new Object[]{Component.m_237110_((String)"hostilenetworks.info.rft", (Object[])new Object[]{cModel.getModel().getSimCost()}).m_130940_(ChatFormatting.GRAY)}));
            List<EntityType<? extends LivingEntity>> subtypes = cModel.getModel().getSubtypes();
            if (!subtypes.isEmpty()) {
                list.add((Component)Component.m_237115_((String)"hostilenetworks.info.subtypes"));
                for (EntityType<? extends LivingEntity> t : subtypes) {
                    list.add((Component)Component.m_237110_((String)"hostilenetworks.info.sub_list", (Object[])new Object[]{t.m_20676_()}).m_130948_(Style.f_131099_.m_178520_(65472)));
                }
            }
        } else {
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.hold_shift", (Object[])new Object[]{Color.withColor("hostilenetworks.color_text.shift", ChatFormatting.WHITE.m_126665_())}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6787_(CreativeModeTab pGroup, NonNullList<ItemStack> pItems) {
        if (this.m_220152_(pGroup)) {
            DataModelManager.INSTANCE.getValues().stream().sorted((m1, m2) -> m1.getId().compareTo(m2.getId())).forEach(model -> {
                ItemStack s = new ItemStack((ItemLike)this);
                DataModelItem.setStoredModel(s, model);
                pItems.add((Object)s);
            });
        }
    }

    public Component m_7626_(ItemStack pStack) {
        DataModel model = DataModelItem.getStoredModel(pStack);
        MutableComponent modelName = model == null ? Component.m_237113_((String)"BROKEN").m_130940_(ChatFormatting.OBFUSCATED) : model.getName();
        return Component.m_237110_((String)this.m_5671_(pStack), (Object[])new Object[]{modelName});
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            DataModelItemStackRenderer dmisr = new DataModelItemStackRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.dmisr;
            }
        });
    }

    @Nullable
    public static DataModel getStoredModel(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        String dmKey = stack.m_41698_(DATA_MODEL).m_128461_(ID);
        return (DataModel)DataModelManager.INSTANCE.getValue(new ResourceLocation(dmKey));
    }

    public static void setStoredModel(ItemStack stack, DataModel model) {
        stack.m_41749_(DATA_MODEL);
        stack.m_41698_(DATA_MODEL).m_128359_(ID, model.getId().toString());
    }

    public static int getData(ItemStack stack) {
        return stack.m_41698_(DATA_MODEL).m_128451_(DATA);
    }

    public static void setData(ItemStack stack, int data) {
        stack.m_41698_(DATA_MODEL).m_128405_(DATA, data);
    }

    public static int getIters(ItemStack stack) {
        return stack.m_41698_(DATA_MODEL).m_128451_(ITERATIONS);
    }

    public static void setIters(ItemStack stack, int data) {
        stack.m_41698_(DATA_MODEL).m_128405_(ITERATIONS, data);
    }

    public static boolean matchesInput(ItemStack model, ItemStack stack) {
        boolean item;
        DataModel dModel = DataModelItem.getStoredModel(model);
        if (dModel == null) {
            return false;
        }
        ItemStack input = dModel.getInput();
        boolean bl = item = input.m_41720_() == stack.m_41720_();
        if (input.m_41782_()) {
            if (stack.m_41782_()) {
                CompoundTag t1 = input.m_41783_();
                CompoundTag t2 = stack.m_41783_();
                for (String s : t1.m_128431_()) {
                    if (t1.m_128423_(s).equals(t2.m_128423_(s))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return item;
    }
}

