/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.config.screen.base.ColorSelectionList;
import terrails.healthoverlay.config.screen.widgets.HeartColorEditBox;
import terrails.healthoverlay.heart.HeartPiece;
import terrails.healthoverlay.heart.HeartType;

public class ColorSelectionScreen
extends Screen {
    private final Screen lastScreen;
    private final boolean health;
    private List<HeartColorEditBox> editBoxes;
    private boolean vanillaHeart;
    private boolean hasChanged;
    private List<Button> heartTypeButtons;
    private Button saveButton;
    private ColorSelectionList colorSelectionList;
    private HeartType heartType;

    public ColorSelectionScreen(Screen lastScreen, boolean health) {
        super((Component)Component.m_237115_((String)(health ? "healthoverlay.screen.title.health" : "healthoverlay.screen.title.absorption")));
        this.lastScreen = lastScreen;
        this.health = health;
        this.updateHeartType(HeartType.NORMAL);
    }

    protected void m_7856_() {
        super.m_7856_();
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int marginY = 40;
        double prevScrollAmount = this.colorSelectionList == null ? 0.0 : this.colorSelectionList.m_93517_();
        this.colorSelectionList = (ColorSelectionList)this.m_142416_((GuiEventListener)new ColorSelectionList(Minecraft.m_91087_(), width, height, marginY, height - marginY, 26));
        this.addColorElements();
        this.colorSelectionList.m_93410_(prevScrollAmount);
        int BUTTON_SPACING = 10;
        int BUTTON_WIDTH = 80;
        int startX = (width - BUTTON_WIDTH * 4 - BUTTON_SPACING * 3) / 2;
        int y = (marginY - 20) / 2;
        this.heartTypeButtons = new ArrayList<Button>();
        Button normalHearts = new Button(startX, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"healthoverlay.option.button.normal"), btn -> this.updateHeartType(HeartType.NORMAL));
        normalHearts.f_93623_ = this.heartType != HeartType.NORMAL;
        this.m_142416_((GuiEventListener)normalHearts);
        this.heartTypeButtons.add(normalHearts);
        int x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        Button poisonedHearts = new Button(x, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"healthoverlay.option.button.poisoned"), btn -> this.updateHeartType(HeartType.POISONED));
        poisonedHearts.f_93623_ = this.heartType != HeartType.POISONED;
        this.m_142416_((GuiEventListener)poisonedHearts);
        this.heartTypeButtons.add(poisonedHearts);
        Button witheredHearts = new Button(x += BUTTON_WIDTH + BUTTON_SPACING, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"healthoverlay.option.button.withered"), btn -> this.updateHeartType(HeartType.WITHERED));
        witheredHearts.f_93623_ = this.heartType != HeartType.WITHERED;
        this.m_142416_((GuiEventListener)witheredHearts);
        this.heartTypeButtons.add(witheredHearts);
        Button frozenHearts = new Button(x += BUTTON_WIDTH + BUTTON_SPACING, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"healthoverlay.option.button.frozen"), btn -> this.updateHeartType(HeartType.FROZEN));
        frozenHearts.f_93623_ = this.heartType != HeartType.FROZEN;
        this.m_142416_((GuiEventListener)frozenHearts);
        this.heartTypeButtons.add(frozenHearts);
        BUTTON_WIDTH = 120;
        BUTTON_SPACING = 30;
        startX = (width - BUTTON_WIDTH * 2 - BUTTON_SPACING) / 2;
        y = height - (marginY - 20) / 2 - marginY / 2;
        Button saveButton = new Button(startX, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"healthoverlay.options.button.confirm"), btn -> {
            this.saveConfig();
            this.m_7379_();
        });
        saveButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)saveButton);
        this.saveButton = saveButton;
        x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        Button cancelButton = new Button(x, y, BUTTON_WIDTH, 20, (Component)Component.m_237115_((String)"healthoverlay.options.button.cancel"), btn -> this.m_7379_());
        this.m_142416_((GuiEventListener)cancelButton);
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.f_93623_ = false;
            });
        }
        if (this.canSave()) {
            this.saveButton.f_93623_ = true;
        }
    }

    public void updateHeartType(HeartType type) {
        this.heartType = type;
        this.vanillaHeart = this.hasVanillaHeartVariant() && this.heartColorsContainVanilla();
        this.editBoxes = null;
        this.m_232761_();
    }

    public boolean canSave() {
        boolean invalidColorsPresent = this.editBoxes.stream().anyMatch(box -> !box.isValidHex());
        long colorCount = this.editBoxes.stream().filter(HeartColorEditBox::isValidHex).count();
        boolean hasEnoughColors = colorCount > 0L && (this.health && (this.heartType == HeartType.NORMAL || this.vanillaHeart || colorCount == 2L) || !this.health && (this.heartType == HeartType.NORMAL || colorCount == 2L));
        return this.hasChanged && !invalidColorsPresent && hasEnoughColors;
    }

    public boolean hasVanillaHeartVariant() {
        return this.health || this.heartType == HeartType.NORMAL;
    }

    private boolean haveValuesChanged() {
        boolean hasVanillaOptionChanged;
        List<HeartPiece> pieces = this.heartColorsWithoutVanilla();
        boolean isSizeEqual = pieces.size() == this.editBoxes.size();
        boolean bl = hasVanillaOptionChanged = !this.hasVanillaHeartVariant() || this.heartType == HeartType.NORMAL && this.vanillaHeart == this.configVanillaHeart().get() || this.heartType != HeartType.NORMAL && this.vanillaHeart == this.heartColorsContainVanilla();
        if (isSizeEqual && hasVanillaOptionChanged) {
            for (int i = 0; i < pieces.size(); ++i) {
                HeartColorEditBox box = this.editBoxes.get(i);
                HeartPiece piece = pieces.get(i);
                if (box.isValidHex() && piece.getHexColor().equalsIgnoreCase(box.m_94155_())) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private List<HeartPiece> heartColorsWithoutVanilla() {
        ArrayList<HeartPiece> pieces = new ArrayList<HeartPiece>((Collection)this.configHeartColor().get());
        if (this.health) {
            pieces.remove(HeartPiece.VANILLA_HEALTH);
        } else {
            pieces.remove(HeartPiece.VANILLA_ABSORPTION);
        }
        return pieces;
    }

    private boolean heartColorsContainVanilla() {
        ArrayList pieces = new ArrayList(this.configHeartColor().get());
        if (this.health) {
            return pieces.contains(HeartPiece.VANILLA_HEALTH);
        }
        return pieces.contains(HeartPiece.VANILLA_ABSORPTION);
    }

    private ConfigOption<Boolean> configVanillaHeart() {
        if (this.health) {
            return Configuration.HEALTH.vanillaHearts;
        }
        return Configuration.ABSORPTION.vanillaHearts;
    }

    private ConfigOption<List<HeartPiece>> configHeartColor() {
        ConfigOption<List<HeartPiece>> heartColors = null;
        if (this.health) {
            switch (this.heartType) {
                case NORMAL: {
                    heartColors = Configuration.HEALTH.normalColors;
                    break;
                }
                case POISONED: {
                    heartColors = Configuration.HEALTH.poisonedColors;
                    break;
                }
                case WITHERED: {
                    heartColors = Configuration.HEALTH.witheredColors;
                    break;
                }
                case FROZEN: {
                    heartColors = Configuration.HEALTH.frozenColors;
                }
            }
        } else {
            switch (this.heartType) {
                case NORMAL: {
                    heartColors = Configuration.ABSORPTION.normalColors;
                    break;
                }
                case POISONED: {
                    heartColors = Configuration.ABSORPTION.poisonedColors;
                    break;
                }
                case WITHERED: {
                    heartColors = Configuration.ABSORPTION.witheredColors;
                    break;
                }
                case FROZEN: {
                    heartColors = Configuration.ABSORPTION.frozenColors;
                }
            }
        }
        return heartColors;
    }

    private void saveConfig() {
        List heartPieces = this.editBoxes.stream().filter(HeartColorEditBox::isValidHex).map(HeartColorEditBox::getHeartPiece).collect(Collectors.toList());
        if (this.hasVanillaHeartVariant() && this.vanillaHeart) {
            if (this.health) {
                heartPieces.add(0, HeartPiece.VANILLA_HEALTH);
            } else {
                heartPieces.add(0, HeartPiece.VANILLA_ABSORPTION);
            }
        }
        if (this.health) {
            if (this.heartType != HeartType.NORMAL && this.vanillaHeart) {
                heartPieces.remove(heartPieces.size() - 1);
            }
            switch (this.heartType) {
                case NORMAL: {
                    Configuration.HEALTH.normalColors.set(heartPieces);
                    Configuration.HEALTH.vanillaHearts.set(this.vanillaHeart);
                    break;
                }
                case POISONED: {
                    Configuration.HEALTH.poisonedColors.set(heartPieces);
                    break;
                }
                case WITHERED: {
                    Configuration.HEALTH.witheredColors.set(heartPieces);
                    break;
                }
                case FROZEN: {
                    Configuration.HEALTH.frozenColors.set(heartPieces);
                }
            }
        } else {
            switch (this.heartType) {
                case NORMAL: {
                    Configuration.ABSORPTION.normalColors.set(heartPieces);
                    Configuration.ABSORPTION.vanillaHearts.set(this.vanillaHeart);
                    break;
                }
                case POISONED: {
                    Configuration.ABSORPTION.poisonedColors.set(heartPieces);
                    break;
                }
                case WITHERED: {
                    Configuration.ABSORPTION.witheredColors.set(heartPieces);
                    break;
                }
                case FROZEN: {
                    Configuration.ABSORPTION.frozenColors.set(heartPieces);
                }
            }
        }
    }

    private void addColorElements() {
        int ELEMENTS_PER_ROW = 4;
        int ELEMENT_SPACING = 6;
        int EDIT_BOX_WIDTH = 60;
        int BUTTON_DIMS = 20;
        int BUTTON_SPACING = 3;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int totalElementWidth = 350;
        int startX = (screenWidth - totalElementWidth) / 2;
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        int OFFSET = 0;
        if (this.hasVanillaHeartVariant()) {
            OFFSET = 1;
            Supplier<Component> componentSupplier = () -> {
                if (this.vanillaHeart) {
                    return Component.m_237115_((String)"healthoverlay.options.button.vanilla_heart.on");
                }
                return Component.m_237115_((String)"healthoverlay.options.button.vanilla_heart.off");
            };
            Button vanillaHeart = new Button(startX, 0, 83, 20, componentSupplier.get(), btn -> {
                this.vanillaHeart = !this.vanillaHeart;
                this.hasChanged = this.haveValuesChanged();
                btn.m_93666_((Component)componentSupplier.get());
                this.m_232761_();
            });
            widgets.add((AbstractWidget)vanillaHeart);
        }
        if (this.editBoxes == null) {
            this.editBoxes = new ArrayList<HeartColorEditBox>();
            List<HeartPiece> pieces = this.heartColorsWithoutVanilla();
            for (HeartPiece piece : pieces) {
                HeartColorEditBox box = new HeartColorEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237119_(), this.heartType, this.health);
                box.m_94144_(piece.getHexColor());
                this.editBoxes.add(box);
            }
        }
        int elementCount = this.editBoxes.size();
        for (int i = 0; i < elementCount; ++i) {
            boolean canHaveMoreHearts;
            boolean isRowDone;
            boolean stopRendering;
            boolean bl = stopRendering = this.health && this.heartType != HeartType.NORMAL && (i > 0 && this.vanillaHeart || i > 1);
            if (stopRendering) {
                this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
                break;
            }
            int index = i;
            int column = (i + OFFSET) % 4;
            int x = startX + column * 89;
            Button button = new Button(x, 0, 20, 20, (Component)Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED), btn -> {
                this.editBoxes.remove(index);
                this.hasChanged = this.haveValuesChanged();
                this.m_232761_();
            });
            HeartColorEditBox box = this.editBoxes.get(index);
            box = new HeartColorEditBox(this.f_96547_, x + 20 + 3, 0, 58, 20, box, (Component)Component.m_237119_(), this.heartType, this.health);
            box.m_94151_(str -> {
                this.hasChanged = this.haveValuesChanged();
            });
            this.editBoxes.set(index, box);
            widgets.add((AbstractWidget)button);
            widgets.add((AbstractWidget)box);
            boolean isFinished = index + 1 == elementCount;
            boolean bl2 = isRowDone = column + 1 == 4;
            if (isRowDone) {
                this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
                widgets.clear();
            }
            if (!isFinished) continue;
            boolean bl3 = canHaveMoreHearts = this.heartType == HeartType.NORMAL || elementCount < 2 && !this.vanillaHeart;
            if (canHaveMoreHearts) {
                column = (column + 1) % 4;
                x = startX + column * 60 + column * 20 + column * 6 + column * 3;
                Button addButton = new Button(x, 0, 20, 20, (Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), btn -> {
                    this.editBoxes.add(new HeartColorEditBox(this.f_96547_, 0, 0, 38, 20, (Component)Component.m_237119_(), this.heartType, this.health));
                    this.hasChanged = this.haveValuesChanged();
                    this.m_232761_();
                });
                widgets.add((AbstractWidget)addButton);
            }
            this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
        }
        if (this.editBoxes.size() == 0) {
            int x = startX + 60 + 20 + 6 + 3;
            Button addButton = new Button(x, 0, 20, 20, (Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), btn -> {
                this.editBoxes.add(new HeartColorEditBox(this.f_96547_, 0, 0, 38, 20, (Component)Component.m_237119_(), this.heartType, this.health));
                this.m_232761_();
            });
            widgets.add((AbstractWidget)addButton);
            this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
        }
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.f_93623_ = false;
            });
            this.saveButton.f_93623_ = this.canSave();
        } else if (this.saveButton.f_93623_) {
            this.m_232761_();
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.lastScreen);
    }
}

