/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallBlock
extends WallBlock
implements IFramedBlock {
    public FramedWallBlock() {
        super(IFramedBlock.createProperties(BlockType.FRAMED_WALL));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false)));
        this.fixShapeMaps();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.STATE_LOCKED});
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = this.updateShapeLockable(state, level, currentPos, () -> super.m_7417_(state, facing, facingState, level, currentPos, facingPos));
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_WALL;
    }

    private void fixShapeMaps() {
        Map<BlockState, VoxelShape> shapeByIndex = (Map<BlockState, VoxelShape>)ObfuscationReflectionHelper.getPrivateValue(WallBlock.class, (Object)this, (String)"f_57955_");
        shapeByIndex = FramedWallBlock.fixShapeMap(shapeByIndex);
        ObfuscationReflectionHelper.setPrivateValue(WallBlock.class, (Object)this, shapeByIndex, (String)"f_57955_");
        Map<BlockState, VoxelShape> collisionShapeByIndex = (Map<BlockState, VoxelShape>)ObfuscationReflectionHelper.getPrivateValue(WallBlock.class, (Object)this, (String)"f_57956_");
        collisionShapeByIndex = FramedWallBlock.fixShapeMap(collisionShapeByIndex);
        ObfuscationReflectionHelper.setPrivateValue(WallBlock.class, (Object)this, collisionShapeByIndex, (String)"f_57956_");
    }

    private static Map<BlockState, VoxelShape> fixShapeMap(Map<BlockState, VoxelShape> map) {
        Preconditions.checkNotNull(map, (Object)"Got a null map?!");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(map);
        for (BlockState state : map.keySet()) {
            builder.put((Object)((BlockState)state.m_61122_((Property)FramedProperties.STATE_LOCKED)), (Object)map.get(state));
        }
        return builder.build();
    }
}

