/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.widget;

import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnticipateOvershootInterpolator;
import icyllis.modernui.animation.ObjectAnimator;
import icyllis.modernui.animation.PropertyValuesHolder;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.core.Context;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.util.FloatProperty;
import icyllis.modernui.widget.RadioButton;
import javax.annotation.Nonnull;

public class ColorButton
extends RadioButton {
    private static final float START_SCALE = 0.8f;
    private static final TimeInterpolator sMagInterpolator = new AnticipateOvershootInterpolator(4.0f);
    private final int mRadius = this.dp(4.0f);
    private int mColor = -1;
    private final Animator mMagAnim = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((FloatProperty)SCALE_X, (float[])new float[]{0.8f, 1.0f}), PropertyValuesHolder.ofFloat((FloatProperty)SCALE_Y, (float[])new float[]{0.8f, 1.0f})});
    private final Animator mMinAnim;

    public ColorButton(Context context) {
        super(context);
        this.mMagAnim.setInterpolator(sMagInterpolator);
        this.mMinAnim = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((FloatProperty)SCALE_X, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((FloatProperty)SCALE_Y, (float[])new float[]{1.0f, 0.8f})});
        this.mMinAnim.setInterpolator(TimeInterpolator.DECELERATE);
        this.setScaleX(0.8f);
        this.setScaleY(0.8f);
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    protected void onDraw(@Nonnull Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = Paint.obtain();
        paint.setColor(this.mColor);
        float inner = (float)this.mRadius * 0.5f;
        canvas.drawRect(inner, inner, (float)this.getWidth() - inner, (float)this.getHeight() - inner, paint);
        if (this.isChecked()) {
            paint.setStyle(1);
            paint.setStrokeWidth((float)this.mRadius);
            paint.setColor(-1);
            canvas.drawRoundRect(inner, inner, (float)this.getWidth() - inner, (float)this.getHeight() - inner, inner, paint);
        }
        paint.recycle();
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        this.invalidate();
    }

    public void onHoverChanged(boolean hovered) {
        super.onHoverChanged(hovered);
        if (hovered) {
            this.mMinAnim.cancel();
            this.mMagAnim.setupStartValues();
            this.mMagAnim.start();
        } else {
            this.mMagAnim.cancel();
            this.mMinAnim.setupStartValues();
            this.mMinAnim.start();
        }
    }
}

