/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.utility;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextUtils {
    private static final MutableComponent NO_EFFECTS = Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY);

    public static MutableComponent getTranslation(String key, Object ... args) {
        return Component.m_237110_((String)("farmersdelight." + key), (Object[])args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addFoodEffectTooltip(ItemStack itemIn, List<Component> lores, float durationFactor) {
        FoodProperties foodStats = itemIn.m_41720_().m_41473_();
        if (foodStats == null) {
            return;
        }
        List effectList = foodStats.m_38749_();
        ArrayList attributeList = Lists.newArrayList();
        if (effectList.isEmpty()) {
            lores.add((Component)NO_EFFECTS);
        } else {
            for (Pair effectPair : effectList) {
                MobEffectInstance instance = (MobEffectInstance)effectPair.getFirst();
                MutableComponent iformattabletextcomponent = Component.m_237115_((String)instance.m_19576_());
                MobEffect effect = instance.m_19544_();
                Map attributeMap = effect.m_19485_();
                if (!attributeMap.isEmpty()) {
                    for (Map.Entry entry : attributeMap.entrySet()) {
                        AttributeModifier rawModifier = (AttributeModifier)entry.getValue();
                        AttributeModifier modifier = new AttributeModifier(rawModifier.m_22214_(), effect.m_7048_(instance.m_19564_(), rawModifier), rawModifier.m_22217_());
                        attributeList.add(new Pair((Object)((Attribute)entry.getKey()), (Object)modifier));
                    }
                }
                if (instance.m_19564_() > 0) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.m_237115_((String)("potion.potency." + instance.m_19564_()))});
                }
                if (instance.m_19557_() > 20) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.m_19581_((MobEffectInstance)instance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!attributeList.isEmpty()) {
            lores.add(CommonComponents.f_237098_);
            lores.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeList) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.m_22218_();
                double formattedAmount = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier.m_22218_() : modifier.m_22218_() * 100.0;
                if (amount > 0.0) {
                    lores.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(formattedAmount), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                lores.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(formattedAmount *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

