/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.gunpowderlib.helper.NBTHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class ItemHandler {
    public static boolean consumeItemInInventory(Item item, Inventory playerInv, Player player) {
        if (player.m_7500_() || ExchangerHandler.getExIsCreative(player.m_21205_())) {
            return true;
        }
        int i = ItemHandler.findItem(item, playerInv);
        if (i < 0) {
            NonNullList<IItemHandler> containers = ItemHandler.findItemContainers(playerInv);
            if (containers.isEmpty()) {
                return false;
            }
            for (IItemHandler container : containers) {
                i = ItemHandler.findItemInContainer(item, container);
                if (i < 0) continue;
                container.extractItem(i, 1, false);
                return true;
            }
        } else {
            playerInv.m_7407_(i, 1);
            return true;
        }
        return false;
    }

    public static int findItem(Item item, Inventory inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    public static int findItemInContainer(Item item, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (inv.extractItem(i, 1, true).m_41619_() || stack.m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    public static NonNullList<IItemHandler> findItemContainers(Inventory inv) {
        NonNullList containers = NonNullList.m_122779_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            IItemHandler container = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
            if (stack.m_41619_() || container == null || stack.getCapability(ForgeCapabilities.ENERGY, null).isPresent()) continue;
            containers.add((Object)container);
        }
        return containers;
    }

    public static ItemStack getSilkTouchDrop(BlockState state) {
        Block block = state.m_60734_();
        Item item = block.m_5456_();
        return new ItemStack((ItemLike)item, 1);
    }

    public static void giveItem(Level world, Player player, ItemStack oldStack) {
        ItemEntity entityItem = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), oldStack);
        if (NBTHelper.getTag((ItemStack)player.m_21205_()).m_128471_("forceDropItems")) {
            world.m_7967_((Entity)entityItem);
        } else if (!player.m_150109_().m_36054_(oldStack)) {
            world.m_7967_((Entity)entityItem);
        }
    }
}

