/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.client.keybind;

import com.mojang.blaze3d.platform.InputConstants;
import jackyy.exchangers.client.keybind.ExchangersKeyConflictContext;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class Keys {
    public static final Lazy<KeyMapping> OPEN_GUI_KEY = Lazy.of(() -> Keys.createKey("open_gui", 44));
    public static final Lazy<KeyMapping> RANGE_SWITCH_KEY = Lazy.of(() -> Keys.createKey("range_switch", -1));
    public static final Lazy<KeyMapping> MODE_SWITCH_KEY = Lazy.of(() -> Keys.createKey("mode_switch", -1));
    public static final Lazy<KeyMapping> FORCE_DROP_ITEMS_KEY = Lazy.of(() -> Keys.createKey("force_drop_items_mode_toggle", -1));
    public static final Lazy<KeyMapping> DIRECTIONAL_PLACEMENT_KEY = Lazy.of(() -> Keys.createKey("directional_placement_mode_toggle", -1));
    public static final Lazy<KeyMapping> FUZZY_PLACEMENT_KEY = Lazy.of(() -> Keys.createKey("fuzzy_placement_mode_toggle", -1));
    public static final Lazy<KeyMapping> VOID_ITEMS_KEY = Lazy.of(() -> Keys.createKey("void_items_mode_toggle", -1));

    private static KeyMapping createKey(String name, int keyCode) {
        return new KeyMapping("key.exchangers." + name, ExchangersKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM, keyCode, "key.categories.exchangers");
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)OPEN_GUI_KEY.get());
        event.register((KeyMapping)RANGE_SWITCH_KEY.get());
        event.register((KeyMapping)MODE_SWITCH_KEY.get());
        event.register((KeyMapping)FORCE_DROP_ITEMS_KEY.get());
        event.register((KeyMapping)DIRECTIONAL_PLACEMENT_KEY.get());
        event.register((KeyMapping)FUZZY_PLACEMENT_KEY.get());
        event.register((KeyMapping)VOID_ITEMS_KEY.get());
    }
}

