/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import jackyy.exchangers.client.gui.ImageButtonExt;
import jackyy.exchangers.client.gui.ToggleButton;
import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.mode.ModeHorizontalCol;
import jackyy.exchangers.handler.mode.ModePlane;
import jackyy.exchangers.handler.mode.ModeVerticalCol;
import jackyy.exchangers.handler.network.NetworkHandler;
import jackyy.exchangers.handler.network.packet.PacketDecreaseRange;
import jackyy.exchangers.handler.network.packet.PacketIncreaseRange;
import jackyy.exchangers.handler.network.packet.PacketSetFuzzyPlacementChance;
import jackyy.exchangers.handler.network.packet.PacketSwitchMode;
import jackyy.exchangers.handler.network.packet.PacketToggleDirectionalPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleForceDropItems;
import jackyy.exchangers.handler.network.packet.PacketToggleFuzzyPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleVoidItems;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.util.Reference;
import jackyy.gunpowderlib.helper.StringHelper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ExchangersGuiScreen
extends Screen {
    private static Minecraft mc = Minecraft.m_91087_();
    private final ResourceLocation GUI_IMAGE = new ResourceLocation("exchangers", "textures/gui/gui_exchanger.png");
    private static final int W = 180;
    private static final int H = 150;
    private String chance;
    private ImageButtonExt decreaseRangeButton;
    private ImageButtonExt increaseRangeButton;
    private ToggleButton modeSwitchButton;
    private ToggleButton forceDropItemsButton;
    private ToggleButton directionalPlacementButton;
    private ToggleButton fuzzyPlacementButton;
    private ToggleButton voidItemsButton;
    private EditBox fuzzyPlacementChanceField;

    public ExchangersGuiScreen() {
        super((Component)Component.m_237115_((String)"screen.exchangers.exchanger_gui.title"));
        this.f_96543_ = 180;
        this.f_96544_ = 150;
    }

    public void m_7856_() {
        int relativeX = (this.f_96543_ - 180) / 2;
        int relativeY = (this.f_96544_ - 150) / 2;
        ItemStack stack = ExchangersGuiScreen.mc.f_91074_.m_21205_();
        CompoundTag tag = stack.m_41783_();
        this.chance = Integer.toString(tag.m_128451_("fuzzyPlacementChance"));
        this.decreaseRangeButton = new ImageButtonExt(relativeX + 54, relativeY + 31, 10, 15, 180, 0, 15, 30, this.GUI_IMAGE, button -> NetworkHandler.sendToServer(new PacketDecreaseRange()));
        this.increaseRangeButton = new ImageButtonExt(relativeX + 116, relativeY + 31, 10, 15, 190, 0, 15, 30, this.GUI_IMAGE, button -> NetworkHandler.sendToServer(new PacketIncreaseRange()));
        this.modeSwitchButton = new ToggleButton(relativeX + 20, relativeY + 66, 20, 20, (Component)Component.m_237113_((String)"\u29c8"), button -> NetworkHandler.sendToServer(new PacketSwitchMode()));
        this.forceDropItemsButton = new ToggleButton(relativeX + 60, relativeY + 66, 20, 20, (Component)Component.m_237113_((String)"\u2b0a"), button -> NetworkHandler.sendToServer(new PacketToggleForceDropItems()));
        this.directionalPlacementButton = new ToggleButton(relativeX + 100, relativeY + 66, 20, 20, (Component)Component.m_237113_((String)"\u2927"), button -> NetworkHandler.sendToServer(new PacketToggleDirectionalPlacement()));
        this.fuzzyPlacementButton = new ToggleButton(relativeX + 52, relativeY + 106, 20, 20, (Component)Component.m_237113_((String)"\u224b"), button -> NetworkHandler.sendToServer(new PacketToggleFuzzyPlacement()));
        this.voidItemsButton = new ToggleButton(relativeX + 140, relativeY + 66, 20, 20, (Component)Component.m_237113_((String)"\u2a37"), button -> NetworkHandler.sendToServer(new PacketToggleVoidItems()));
        this.m_142416_((GuiEventListener)this.decreaseRangeButton);
        this.m_142416_((GuiEventListener)this.increaseRangeButton);
        this.m_142416_((GuiEventListener)this.modeSwitchButton);
        this.m_142416_((GuiEventListener)this.forceDropItemsButton);
        this.m_142416_((GuiEventListener)this.directionalPlacementButton);
        this.m_142416_((GuiEventListener)this.fuzzyPlacementButton);
        this.m_142416_((GuiEventListener)this.voidItemsButton);
        this.fuzzyPlacementChanceField = new EditBox(this.f_96547_, relativeX + 92, relativeY + 108, 26, 16, (Component)Component.m_237119_());
        this.fuzzyPlacementChanceField.m_94199_(3);
        this.fuzzyPlacementChanceField.m_94144_(this.chance);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Font fontRenderer = ExchangersGuiScreen.mc.f_91062_;
        ItemStack stack = ExchangersGuiScreen.mc.f_91074_.m_21205_();
        ItemExchangerBase exchanger = (ItemExchangerBase)stack.m_41720_();
        CompoundTag tag = stack.m_41783_();
        this.m_7333_(matrixStack);
        int relativeX = (this.f_96543_ - 180) / 2;
        int relativeY = (this.f_96544_ - 150) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI_IMAGE);
        this.m_93228_(matrixStack, relativeX, relativeY, 0, 0, 180, 150);
        this.f_96542_.m_115203_(stack, relativeX + 82, relativeY + 8);
        int range = tag.m_128451_("range");
        String exchangeRange = ExchangerHandler.rangeList[range];
        fontRenderer.m_92750_(matrixStack, exchangeRange, (float)(relativeX + 90) - (float)fontRenderer.m_92895_(exchangeRange) / 2.0f, (float)(relativeY + 34), -1);
        this.fuzzyPlacementChanceField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        fontRenderer.m_92750_(matrixStack, "%", (float)(relativeX + 121), (float)(relativeY + 112), -1);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.decreaseRangeButton.setButtonDisabled(range == 0);
        this.increaseRangeButton.setButtonDisabled(range == exchanger.getMaxRange());
        this.forceDropItemsButton.setButtonToggled(tag.m_128471_("forceDropItems"));
        this.directionalPlacementButton.setButtonToggled(tag.m_128471_("directionalPlacement"));
        this.fuzzyPlacementButton.setButtonToggled(tag.m_128471_("fuzzyPlacement"));
        this.voidItemsButton.setButtonToggled(tag.m_128471_("voidItems"));
        if (this.decreaseRangeButton.m_198029_()) {
            this.drawToolTip(matrixStack, Collections.singletonList(StringHelper.localize((String)"exchangers", (String)"tooltip.decrease_range_button", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.increaseRangeButton.m_198029_()) {
            this.drawToolTip(matrixStack, Collections.singletonList(StringHelper.localize((String)"exchangers", (String)"tooltip.increase_range_button", (Object[])new Object[0])), mouseX, mouseY);
        }
        if (this.modeSwitchButton.m_198029_()) {
            int mode = tag.m_128451_("mode");
            switch (mode) {
                case 0: {
                    this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.mode_switch_button", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModePlane.getDisplayName().m_130940_(ChatFormatting.GREEN)})), mouseX, mouseY);
                    break;
                }
                case 1: {
                    this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.mode_switch_button", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeHorizontalCol.getDisplayName().m_130940_(ChatFormatting.GREEN)})), mouseX, mouseY);
                    break;
                }
                case 2: {
                    this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.mode_switch_button", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.current_mode", (Object[])new Object[]{ModeVerticalCol.getDisplayName().m_130940_(ChatFormatting.GREEN)})), mouseX, mouseY);
                }
            }
        }
        if (this.forceDropItemsButton.m_198029_()) {
            this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.force_drop_items_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.force_drop_items_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.m_128471_("forceDropItems"))})), mouseX, mouseY);
        }
        if (this.directionalPlacementButton.m_198029_()) {
            this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.directional_placement_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.directional_placement_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.m_128471_("directionalPlacement"))})), mouseX, mouseY);
        }
        if (this.fuzzyPlacementButton.m_198029_()) {
            this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.m_128471_("fuzzyPlacement"))})), mouseX, mouseY);
        }
        if (this.voidItemsButton.m_198029_()) {
            this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.void_items_button_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.void_items_button_desc", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.state", (Object[])new Object[]{Reference.getStateString(tag.m_128471_("voidItems"))})), mouseX, mouseY);
        }
        if (this.fuzzyPlacementChanceField.m_5953_((double)mouseX, (double)mouseY)) {
            this.drawToolTip(matrixStack, (List<Component>)ImmutableList.of((Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_chance_box_name", (Object[])new Object[0]), (Object)StringHelper.localize((String)"exchangers", (String)"tooltip.fuzzy_placement_chance_box_desc", (Object[])new Object[0])), mouseX, mouseY);
        }
    }

    private void drawToolTip(PoseStack matrixStack, List<Component> tooltips, int x, int y) {
        Screen screen = ExchangersGuiScreen.mc.f_91080_;
        if (screen == null) {
            return;
        }
        screen.renderTooltip(matrixStack, tooltips, ItemStack.f_41583_.m_150921_(), x, y, this.f_96547_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.fuzzyPlacementChanceField.m_6375_(mouseX, mouseY, button);
        if (!this.fuzzyPlacementChanceField.m_93696_()) {
            if (!this.fuzzyPlacementChanceField.m_94155_().isEmpty()) {
                this.parseFuzzyPlacementChance(this.fuzzyPlacementChanceField, 1, 100);
                return super.m_6375_(mouseX, mouseY, button);
            }
            this.fuzzyPlacementChanceField.m_94144_(this.chance);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (259 == keyCode || 261 == keyCode || 263 == keyCode || 262 == keyCode || 268 == keyCode || 269 == keyCode) {
            return this.fuzzyPlacementChanceField.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.fuzzyPlacementChanceField.m_93696_()) {
            if (!(256 != keyCode && 257 != keyCode && 335 != keyCode || this.fuzzyPlacementChanceField.m_94155_().isEmpty())) {
                this.fuzzyPlacementChanceField.m_5755_(false);
                this.parseFuzzyPlacementChance(this.fuzzyPlacementChanceField, 1, 100);
                return true;
            }
        } else if (256 == keyCode || ((KeyMapping)Keys.OPEN_GUI_KEY.get()).getKey().m_84873_() == keyCode || ExchangersGuiScreen.mc.f_91066_.f_92092_.getKey().m_84873_() == keyCode) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.fuzzyPlacementChanceField.m_93696_() && Character.isDigit(codePoint)) {
            this.fuzzyPlacementChanceField.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private void parseFuzzyPlacementChance(EditBox field, int min, int max) {
        try {
            boolean valid;
            int value = Integer.parseInt(field.m_94155_());
            boolean bl = valid = value >= min && value <= max;
            if (valid) {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSetFuzzyPlacementChance(value));
                this.chance = String.valueOf(value);
            } else {
                NetworkHandler.INSTANCE.sendToServer((Object)new PacketSetFuzzyPlacementChance(max));
                this.chance = String.valueOf(max);
                field.m_94144_(String.valueOf(max));
            }
        }
        catch (NumberFormatException exception) {
            NetworkHandler.INSTANCE.sendToServer((Object)new PacketSetFuzzyPlacementChance(max));
            this.chance = String.valueOf(max);
            field.m_94144_(String.valueOf(max));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return false;
    }
}

