/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;

public class ModelBoxOfEternalClosureBaked
extends DelegatingDynamicItemAndBlockModel {
    protected static final ItemTransforms TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemTransforms.TransformType.GUI, (Object)new ItemTransform(new Vector3f(30.0f, 135.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f))));
    public static BakedModel boxModel;
    public static BakedModel boxLidModel;
    public static BakedModel boxLidRotatedModel;
    private final boolean isOpen;

    public ModelBoxOfEternalClosureBaked() {
        this.isOpen = false;
    }

    public ModelBoxOfEternalClosureBaked(boolean isOpen, ItemStack itemStack, Level world, LivingEntity entity) {
        super(itemStack, world, entity);
        this.isOpen = isOpen;
    }

    public List<BakedQuad> getGeneralQuads() {
        if (!this.isItemStack()) {
            return Collections.emptyList();
        }
        LinkedList quads = Lists.newLinkedList();
        quads.addAll(boxModel.m_213637_(this.blockState, this.facing, this.rand));
        if (this.isOpen) {
            quads.addAll(boxLidRotatedModel.m_213637_(this.blockState, this.facing, this.rand));
        } else {
            quads.addAll(boxLidModel.m_213637_(this.blockState, this.facing, this.rand));
        }
        return quads;
    }

    public BakedModel handleBlockState(BlockState state, Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        return null;
    }

    public BakedModel handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        return new ModelBoxOfEternalClosureBaked(BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(itemStack) == null, itemStack, world, entity);
    }

    public TextureAtlasSprite m_6160_() {
        return boxModel.m_6160_();
    }

    public boolean m_7547_() {
        return false;
    }

    public ItemTransforms m_7442_() {
        return TRANSFORMS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelBoxOfEternalClosureBaked)) {
            return false;
        }
        ModelBoxOfEternalClosureBaked other = (ModelBoxOfEternalClosureBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isOpen() == other.isOpen();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelBoxOfEternalClosureBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOpen() ? 79 : 97);
        return result;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return "ModelBoxOfEternalClosureBaked(isOpen=" + this.isOpen() + ")";
    }
}

