/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.storage;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.world.level.GameType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.storage.StorageProvider;

public class StorageProviderRemote
implements StorageProvider {
    @Override
    public boolean checkPassword(String username, String password) {
        return StorageProviderRemote.validateToken(username, password);
    }

    @Override
    public void unregister(String username) {
    }

    @Override
    public boolean registered(String username) {
        return true;
    }

    @Override
    public void register(String username, String password) {
        throw new NotImplementedException();
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public GameType gameType(String username) {
        return GameType.SURVIVAL;
    }

    @Override
    public void setGameType(String username, GameType gameType) {
    }

    @Override
    public void changePassword(String username, String newPassword) {
        throw new NotImplementedException();
    }

    @Override
    public boolean dirty() {
        return false;
    }

    @Override
    public Collection<String> getAllRegisteredUsername() {
        return new ArrayList<String>();
    }

    private static boolean validateToken(String username, String token) {
        try {
            String resp;
            URL url = new URL("https://ftbhungary.hu/api/auth/verify");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            try {
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/json");
                conn.setDoOutput(true);
                conn.getOutputStream().write(("{\"access_token\":\"" + token + "\"}").getBytes(StandardCharsets.UTF_8));
                resp = new String(IOUtils.toByteArray((InputStream)conn.getInputStream()), StandardCharsets.UTF_8).intern();
            }
            catch (IOException ex) {
                try {
                    resp = new String(IOUtils.toByteArray((InputStream)conn.getErrorStream()), StandardCharsets.UTF_8).intern();
                }
                catch (Exception ignored) {
                    throw ex;
                }
            }
            try {
                SimpleLogin.logger.info(resp);
                JsonObject root = JsonParser.parseString((String)resp).getAsJsonObject();
                return (!root.has("status") || !root.get("status").getAsString().equalsIgnoreCase("error")) && root.has("username") && root.get("username").getAsString().toLowerCase().equals(username);
            }
            catch (JsonParseException | ClassCastException ex) {
                SimpleLogin.logger.error("Error during authentication", ex);
                return false;
            }
        }
        catch (Exception e) {
            SimpleLogin.logger.error("Error during authentication", (Throwable)e);
            return false;
        }
    }
}

