/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record VineDecoration(float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos pos, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
        boolean ew = piece.f_73379_ == Rotation.NONE || piece.f_73379_ == Rotation.CLOCKWISE_180;
        int maxX = ew ? model.width : model.length;
        int maxZ = ew ? model.length : model.width;
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < model.height; ++y) {
                for (int z = 0; z < maxZ; ++z) {
                    boolean _up;
                    BlockPos currentPos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    if (!worldGenBounds.m_71051_((Vec3i)currentPos) || !structureBounds.m_71051_((Vec3i)currentPos) || DungeonBuilder.isBlockProtected(world, currentPos) || !world.m_46859_(currentPos)) continue;
                    BlockPos north = currentPos.m_122012_();
                    BlockPos east = currentPos.m_122029_();
                    BlockPos south = currentPos.m_122019_();
                    BlockPos west = currentPos.m_122024_();
                    BlockPos up = currentPos.m_7494_();
                    boolean _north = worldGenBounds.m_71051_((Vec3i)north) && structureBounds.m_71051_((Vec3i)north) && VineBlock.m_57853_((BlockGetter)world, (BlockPos)north, (Direction)Direction.NORTH);
                    boolean _east = worldGenBounds.m_71051_((Vec3i)east) && structureBounds.m_71051_((Vec3i)east) && VineBlock.m_57853_((BlockGetter)world, (BlockPos)east, (Direction)Direction.EAST);
                    boolean _south = worldGenBounds.m_71051_((Vec3i)south) && structureBounds.m_71051_((Vec3i)south) && VineBlock.m_57853_((BlockGetter)world, (BlockPos)south, (Direction)Direction.SOUTH);
                    boolean _west = worldGenBounds.m_71051_((Vec3i)west) && structureBounds.m_71051_((Vec3i)west) && VineBlock.m_57853_((BlockGetter)world, (BlockPos)west, (Direction)Direction.WEST);
                    boolean bl = _up = worldGenBounds.m_71051_((Vec3i)up) && structureBounds.m_71051_((Vec3i)up) && VineBlock.m_57853_((BlockGetter)world, (BlockPos)up, (Direction)Direction.UP);
                    if (!_north && !_east && !_south && !_west && !_up || !(random.m_188501_() < this.chance)) continue;
                    world.m_7731_(currentPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(_north))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(_east))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(_south))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(_west))).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(_up)), 2);
                }
            }
        }
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "vines");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        return object;
    }
}

