/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blocks;

import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.blocks.DimBlockBase;
import edivad.dimstorage.setup.Registration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class DimTank
extends DimBlockBase
implements SimpleWaterloggedBlock {
    private static final VoxelShape BOX = DimTank.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public DimTank() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60918_(SoundType.f_56744_).m_60999_().m_60978_(3.5f).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityDimTank(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return DimTank.createDimBlockTicker(level, blockEntityType, (BlockEntityType<? extends BlockEntityFrequencyOwner>)((BlockEntityType)Registration.DIMTANK_TILE.get()));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof BlockEntityDimTank) {
            BlockEntityDimTank tank = (BlockEntityDimTank)blockentity;
            if (!player.m_6047_()) {
                return tank.activate(player, level, pos, hand);
            }
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public int getLightEmission(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        BlockEntity blockentity = blockGetter.m_7702_(pos);
        if (blockentity instanceof BlockEntityDimTank) {
            BlockEntityDimTank tank = (BlockEntityDimTank)blockentity;
            FluidStack fluid = tank.liquidState.clientLiquid;
            if (!fluid.isEmpty()) {
                FluidType fluidType = fluid.getFluid().getFluidType();
                if (blockGetter instanceof BlockAndTintGetter) {
                    BlockAndTintGetter blockAndTint = (BlockAndTintGetter)blockGetter;
                    return fluidType.getLightLevel(fluid.getFluid().m_76145_(), blockAndTint, pos);
                }
                return fluidType.getLightLevel(fluid);
            }
        }
        return 0;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int n;
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof BlockEntityDimTank) {
            BlockEntityDimTank tank = (BlockEntityDimTank)te;
            n = tank.getComparatorInput();
        } else {
            n = 0;
        }
        return n;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(levelAccessor, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(blockGetter, pos, state, fluidIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }
}

