/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jomcraft.defaultsettings.DefaultSettings;
import net.jomcraft.defaultsettings.FileUtil;
import net.jomcraft.defaultsettings.commands.ConfigArguments;
import net.jomcraft.defaultsettings.commands.MutableBoolean;
import net.jomcraft.defaultsettings.commands.OperationArguments;
import net.jomcraft.defaultsettings.commands.ThreadRunnable;
import net.jomcraft.defaultsettings.commands.TypeArguments;
import net.jomcraft.jcplugin.FileUtilNoMC;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.Level;

public class CommandDefaultSettings {
    private static ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)Component.m_237113_((String)(ChatFormatting.RED + "Please wait until the last request has finished")));

    public static void register(ServerStartingEvent event) {
        LiteralArgumentBuilder literalargumentbuilder = Commands.m_82127_((String)"defaultsettings");
        ((LiteralArgumentBuilder)literalargumentbuilder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"save").executes(command -> CommandDefaultSettings.saveProcess((CommandSourceStack)command.getSource(), null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"operation", (ArgumentType)OperationArguments.operationArguments(false)).executes(command -> CommandDefaultSettings.saveProcess((CommandSourceStack)command.getSource(), OperationArguments.getString(command, "operation"), null))).then(Commands.m_82129_((String)"type", (ArgumentType)TypeArguments.typeArguments()).executes(command -> CommandDefaultSettings.saveProcess((CommandSourceStack)command.getSource(), OperationArguments.getString(command, "operation"), TypeArguments.getString(command, "type"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"saveconfigs").executes(command -> CommandDefaultSettings.saveProcessConfigs((CommandSourceStack)command.getSource(), null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"operation", (ArgumentType)OperationArguments.operationArguments(true)).executes(command -> CommandDefaultSettings.saveProcessConfigs((CommandSourceStack)command.getSource(), OperationArguments.getString(command, "operation"), null))).then(Commands.m_82129_((String)"config", (ArgumentType)ConfigArguments.configArguments()).executes(command -> CommandDefaultSettings.saveProcessConfigs((CommandSourceStack)command.getSource(), OperationArguments.getString(command, "operation"), ConfigArguments.getString(command, "config"))))));
        LiteralCommandNode node = event.getServer().m_129892_().m_82094_().register(literalargumentbuilder);
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"ds").redirect((CommandNode)node));
    }

    private static int saveProcessConfigs(final CommandSourceStack source, final String argument, final String argument2) throws CommandSyntaxException {
        if (tpe.getQueue().size() > 0) {
            throw FAILED_EXCEPTION.create();
        }
        if (DefaultSettings.shutDown) {
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "DefaultSettings is missing the JCPlugin mod! Shutting down...")), true);
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Reason: " + DefaultSettings.shutdownReason)), true);
            return 0;
        }
        if (!CommandDefaultSettings.shouldExecute(source)) {
            return 0;
        }
        MutableBoolean issue = new MutableBoolean(false);
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    boolean somethingChanged = FileUtilNoMC.checkChangedConfig();
                    if (somethingChanged && (argument == null || !argument.equals("forceOverride"))) {
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "\n\n")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "You seem to have updated certain config files!")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Users who already play your pack won't (!) receive those changes.\n")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "If you want to ship the new configs to those players too,")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "append the 'forceOverride' argument")), true);
                    }
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                    source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Couldn't save the config files!")), true);
                    this.issue.setBoolean(true);
                }
                if (this.issue.getBoolean()) {
                    source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + "Please inspect the log files for further information!")), true);
                } else {
                    try {
                        boolean updateExisting = argument != null && argument.equals("forceOverride");
                        FileUtilNoMC.checkMD5((boolean)updateExisting, (boolean)true, (String)(argument2 == null ? null : argument2));
                        FileUtilNoMC.copyAndHashPrivate((boolean)false, (boolean)true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "Successfully saved your mod configuration files" + (argument2 == null ? "" : (argument2.contains("*") ? " (wildcard)" : " (single entry)")))), true);
                        boolean noFiles = FileUtilNoMC.checkForConfigFiles();
                        if (noFiles) {
                            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + "Warning: No config files will be shipped as the folder is still empty!")), true);
                        }
                    }
                    catch (IOException | UncheckedIOException | NullPointerException e) {
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Couldn't save the config files!")), true);
                        if (e instanceof UncheckedIOException && e.getCause() instanceof NoSuchFileException) {
                            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "It seems, no file or folder by that name exists")), true);
                        }
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving your configuration:", (Throwable)e);
                    }
                }
            }
        });
        return 0;
    }

    public static boolean shouldExecute(CommandSourceStack source) {
        if (FileUtilNoMC.otherCreator) {
            if (!FileUtilNoMC.privateJson.disableCreatorCheck) {
                source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "You're not the creator of this modpack! Using these creator-only commands might come with unforeseen problems.")), true);
                source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "If you're fine with those risks, you may change `\"disableCreatorCheck\": \"false\"` in the `ds_private_storage.json` file to `true`")), true);
                return false;
            }
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Caution! You disabled the creator checker! This might break things!")), true);
            return true;
        }
        return true;
    }

    private static int saveProcess(final CommandSourceStack source, final String argument, final String argument2) throws CommandSyntaxException {
        if (tpe.getQueue().size() > 0) {
            throw FAILED_EXCEPTION.create();
        }
        if (DefaultSettings.shutDown) {
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "DefaultSettings is missing the JCPlugin mod! Shutting down...")), true);
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Reason: " + DefaultSettings.shutdownReason)), true);
            return 0;
        }
        if (!CommandDefaultSettings.shouldExecute(source)) {
            return 0;
        }
        if ((FileUtilNoMC.keysFileExist() || FileUtilNoMC.optionsFilesExist() || FileUtilNoMC.serversFileExists()) && (argument == null || !argument.equals("override") && !argument.equals("forceOverride"))) {
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "These files already exist! If you want to overwrite")), true);
            source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "them, add the 'override' argument")), true);
            return 0;
        }
        MutableBoolean issue = new MutableBoolean(false);
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    boolean somethingChanged = FileUtil.checkChanged();
                    if (somethingChanged && !argument.equals("forceOverride")) {
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "\n\n")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "You seem to have updated certain config files!")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Users who already play your pack won't (!) receive those changes.\n")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "If you want to ship the new configs to those players too,")), true);
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "append the 'forceOverride' argument instead of 'override'")), true);
                    }
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    if (argument2 == null || argument2.equals("keybinds")) {
                        FileUtil.saveKeys();
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "Successfully saved the key configuration")), true);
                        FileUtil.restoreKeys(true, false);
                    }
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                    source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Couldn't save the key configuration!")), true);
                    this.issue.setBoolean(true);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    if (argument2 == null || argument2.equals("options")) {
                        boolean optifine = FileUtil.saveOptions();
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "Successfully saved the default game options" + (optifine ? " (+ Optifine)" : ""))), true);
                    }
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                    source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Couldn't save the default game options!")), true);
                    this.issue.setBoolean(true);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    if (argument2 == null || argument2.equals("servers")) {
                        FileUtilNoMC.saveServers();
                        source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + "Successfully saved the server list")), true);
                    }
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                    source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Couldn't save the server list!")), true);
                    this.issue.setBoolean(true);
                }
                if (this.issue.getBoolean()) {
                    source.m_81354_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + "Please inspect the log files for further information!")), true);
                } else {
                    try {
                        boolean updateExisting = argument != null && argument.equals("forceOverride");
                        FileUtilNoMC.checkMD5((boolean)updateExisting, (boolean)false, null);
                        FileUtilNoMC.copyAndHashPrivate((boolean)true, (boolean)false);
                    }
                    catch (IOException e) {
                        DefaultSettings.log.log(Level.ERROR, "An exception occurred while saving your configuration:", (Throwable)e);
                    }
                }
            }
        });
        return 0;
    }
}

