/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.jomcraft.defaultsettings.EventHandlers;
import net.jomcraft.defaultsettings.FileUtil;
import net.jomcraft.defaultsettings.KeyContainer;
import net.jomcraft.defaultsettings.commands.ConfigArguments;
import net.jomcraft.defaultsettings.commands.OperationArguments;
import net.jomcraft.defaultsettings.commands.TypeArguments;
import net.jomcraft.jcplugin.FileUtilNoMC;
import net.jomcraft.jcplugin.JCLogger;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="defaultsettings")
public class DefaultSettings {
    public static final String MODID = "defaultsettings";
    public static final Logger log = LogManager.getLogger((String)"defaultsettings");
    public static final String VERSION = DefaultSettings.class.getPackage().getImplementationVersion();
    public static Map<String, KeyContainer> keyRebinds = new HashMap<String, KeyContainer>();
    public static boolean setUp = false;
    public static DefaultSettings instance;
    public static boolean shutDown;
    public static String shutdownReason;
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;

    public DefaultSettings() {
        instance = this;
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (setUp) {
                return;
            }
            try {
                Field pluginClass = Class.forName("net.jomcraft.jcplugin.JCPlugin").getDeclaredField("checksSuccessful");
                if (!pluginClass.getBoolean(null)) {
                    shutDown = true;
                    shutdownReason = "The JCPlugin mod couldn't be found! Please make sure that the correct version (probably " + VERSION + ") is installed!";
                    log.log(Level.ERROR, "DefaultSettings can't start up! Something is hella broken! Shutting down...");
                } else {
                    Path location = (Path)Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).get();
                    File mods = new File(location.toFile(), "mods");
                    boolean foundDefaultSettings = false;
                    String wantedVersion = null;
                    for (File mod : mods.listFiles()) {
                        if (!mod.getName().toLowerCase().contains(MODID)) continue;
                        JarFile jar = new JarFile(mod);
                        ZipEntry toml = jar.getEntry("META-INF/MANIFEST.MF");
                        if (toml != null) {
                            String readerLine;
                            BufferedReader result = new BufferedReader(new InputStreamReader(jar.getInputStream(toml)));
                            while ((readerLine = result.readLine()) != null) {
                                if (readerLine.contains("Implementation-Title: DefaultSettings")) {
                                    foundDefaultSettings = true;
                                    continue;
                                }
                                if (!readerLine.startsWith("JCPluginVersion")) continue;
                                wantedVersion = readerLine.split(": ")[1];
                            }
                            result.close();
                        }
                        jar.close();
                        if (!foundDefaultSettings || wantedVersion == null) continue;
                        if (wantedVersion.equals(JCLogger.class.getPackage().getImplementationVersion())) {
                            log.log(Level.INFO, "DefaultSettings found correct version of JCPlugin, starting up...");
                            break;
                        }
                        shutDown = true;
                        shutdownReason = "The correct JCPlugin mod version couldn't be found! Please install version " + wantedVersion;
                        log.log(Level.ERROR, "DefaultSettings can't start up! JCPlugin version must be " + wantedVersion + "!");
                    }
                    if (!foundDefaultSettings || wantedVersion == null) {
                        shutDown = true;
                        shutdownReason = "Strange! We can't find the DefaultSettings mod, eventhough you're currently using it!";
                        log.log(Level.ERROR, "DefaultSettings can't start up! Couldn't get requested version of JCPlugin!");
                    }
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                shutDown = true;
                shutdownReason = "The JCPlugin mod couldn't be found! Please make sure that the correct version (probably " + VERSION + ") is installed!";
                log.log(Level.ERROR, "DefaultSettings is missing the JCPlugin mod! Shutting down...");
            }
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postInit);
            COMMAND_ARGUMENT_TYPES.register("ds_config", () -> (ConfigArguments.Info)ArgumentTypeInfos.registerByClass(ConfigArguments.class, (ArgumentTypeInfo)new ConfigArguments.Info()));
            COMMAND_ARGUMENT_TYPES.register("ds_operation", () -> (OperationArguments.Info)ArgumentTypeInfos.registerByClass(OperationArguments.class, (ArgumentTypeInfo)new OperationArguments.Info()));
            COMMAND_ARGUMENT_TYPES.register("ds_type", () -> (TypeArguments.Info)ArgumentTypeInfos.registerByClass(TypeArguments.class, (ArgumentTypeInfo)new TypeArguments.Info()));
            COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
            ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
            MinecraftForge.EVENT_BUS.register(DefaultSettings.class);
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
            if (shutDown) {
                return;
            }
            try {
                FileUtil.restoreContents();
            }
            catch (Exception e) {
                log.log(Level.ERROR, "An exception occurred while starting up the game:", (Throwable)e);
            }
            setUp = true;
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> log.log(Level.WARN, "DefaultSettings is a client-side mod only! It won't do anything on servers!"));
    }

    public void postInit(FMLLoadCompleteEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                if (!shutDown) {
                    FileUtil.restoreKeys(true, FileUtilNoMC.privateJson.firstBootUp);
                }
            }
            catch (IOException e) {
                log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
            }
            catch (NullPointerException e) {
                log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
            }
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> log.log(Level.WARN, "DefaultSettings is a client-side mod only! It won't do anything on servers!"));
    }

    public static DefaultSettings getInstance() {
        return instance;
    }

    static {
        shutDown = false;
        shutdownReason = null;
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.COMMAND_ARGUMENT_TYPES, (String)MODID);
    }
}

