/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory.item;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemInventoryWrapper
implements Container {
    private final ItemStack inventory;
    private final int size;
    private final NonNullList<ItemStack> slots;
    private CompoundTag tag;
    private boolean dirty = false;

    public ItemInventoryWrapper(ItemStack inventory, int size) {
        this.inventory = inventory;
        this.size = size;
        this.slots = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.load();
        this.m_6596_();
    }

    public void load() {
        CompoundTag nbt = this.inventory.m_41783_();
        if (nbt != null && !nbt.m_128441_("Items")) {
            if (this.inventory.m_41782_()) {
                this.tag = nbt;
                this.loadItems();
                this.tag = new CompoundTag();
                this.saveItems();
            } else {
                this.inventory.m_41700_("Inventory", (Tag)new CompoundTag());
            }
            this.tag = nbt.m_128469_("Inventory");
            this.loadItems();
        }
    }

    protected void loadItems() {
        for (int i = 0; i < this.size; ++i) {
            if (this.tag.m_128441_("Slot")) {
                this.slots.set(i, (Object)ItemStack.m_41712_((CompoundTag)this.tag.m_128469_("Slot" + i)));
                continue;
            }
            this.slots.set(i, (Object)ItemStack.f_41583_);
        }
    }

    protected void saveItems() {
        for (int i = 0; i < this.size; ++i) {
            if (((ItemStack)this.slots.get(i)).m_41619_()) {
                this.tag.m_128473_("Slot" + i);
                continue;
            }
            this.tag.m_128365_("Slot" + i, (Tag)((ItemStack)this.slots.get(i)).m_41739_(new CompoundTag()));
        }
        this.inventory.m_41700_("Items", (Tag)this.tag);
    }

    public ItemStack getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.slots;
    }

    public boolean getDirty() {
        boolean dirt = this.dirty;
        this.dirty = false;
        return dirt;
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        return this.slots.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.slots, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.slots, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.slots.set(index, (Object)stack);
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
        this.saveItems();
        this.dirty = true;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
        this.m_6596_();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public void m_6211_() {
    }
}

