/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.IsInsideStructureTracker;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class InsideStructureTagCondition
implements Condition {
    public static final Codec<InsideStructureTagCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.m_203877_((ResourceKey)Registry.f_235725_).listOf().fieldOf("structure_tag_is").forGetter(insideStructureTagCondition -> insideStructureTagCondition.structureTags), (App)Codec.BOOL.optionalFieldOf("in_piece", (Object)false).forGetter(insideStructureTagCondition -> insideStructureTagCondition.intersectsPiece)).apply((Applicative)builder, InsideStructureTagCondition::new));
    private final List<TagKey<Structure>> structureTags;
    private final boolean intersectsPiece;

    public InsideStructureTagCondition(List<TagKey<Structure>> structureTags, boolean mustIntersectPiece) {
        if (structureTags.isEmpty()) {
            throw new IllegalArgumentException("No structures were specified.");
        }
        this.structureTags = structureTags;
        this.intersectsPiece = mustIntersectPiece;
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        Level world = conditionContext.world();
        LivingEntity entity = conditionContext.entity();
        if (world.f_46443_) {
            return this.clientPasses((IsInsideStructureTracker.Access)entity);
        }
        Registry configuredStructureFeatures = world.m_5962_().m_175515_(Registry.f_235725_);
        for (TagKey<Structure> structureTag : this.structureTags) {
            HolderSet.Named tag = configuredStructureFeatures.m_203561_(structureTag);
            List structures = tag.m_203614_().toList();
            for (Holder structure : structures) {
                BlockPos entityPosition = entity.m_20183_();
                Optional possibleStructureStart = ((ServerLevel)world).m_215010_().m_220504_(SectionPos.m_123199_((BlockPos)entityPosition), (Structure)structure.m_203334_()).stream().findFirst();
                if (possibleStructureStart.isEmpty()) {
                    return false;
                }
                StructureStart structureStart = (StructureStart)possibleStructureStart.get();
                if (this.intersectsPiece) {
                    for (StructurePiece piece : structureStart.m_73602_()) {
                        if (piece.m_73547_().m_71051_((Vec3i)entityPosition)) {
                            ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(true, true));
                            return true;
                        }
                        ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(structureStart.m_73601_().m_71051_((Vec3i)entityPosition), false));
                    }
                    continue;
                }
                if (structureStart.m_73601_().m_71051_((Vec3i)entityPosition)) {
                    ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(true, false));
                    return true;
                }
                ((IsInsideStructureTracker.Access)entity).getIsInsideStructureTracker().setInside(world, (Entity)entity, new IsInsideStructureTracker.IsInside(false, true));
            }
        }
        return false;
    }

    private boolean clientPasses(IsInsideStructureTracker.Access entity) {
        IsInsideStructureTracker.IsInside tracker = entity.getIsInsideStructureTracker().getTracker();
        return tracker.isInsideStructurePiece() && this.intersectsPiece || tracker.isInsideStructure();
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

